/**
*
**/
  "use strict";
define(function () {
  var gcMapUtils = function() {
    this.$get = function() {
      var attributions = {};
      return {


        
        /**
         * Search for an overlay identified by bodId in the map and
         * return it. undefined is returned if the map does not have
         * such a layer.
         */
        getMapOverlayForBodId: function(map, bodId) {
          var layer;
          map.getLayers().forEach(function(l) {
            if (l.bodId == bodId && !l.background && !l.preview) {
              layer = l;
            }
          });
          return layer;
        },

        /**
         * Manage map attributions.
         */
        getAttribution: function(text) {
          var key = text;
          if (key in attributions) {
            return attributions[key];
          } else {
            var a = new ol.Attribution({html: text});
            attributions[key] = a;
            return a;
          }
        }
      };
    };
  };

  gcMapUtils.$inject = [];
  return gcMapUtils;
});