(function (require) {

    var tests = [];
    for (var file in window.__karma__.files) {
        if (window.__karma__.files.hasOwnProperty(file)) {

            // retrieve all Spec files
            if (/Spec\.js$/.test(file)) {
                tests.push(file); 
            }
        }
    }

    requirejs.config({

        // Karma serves files from '/base'
        baseUrl: '/base/js/XG',
        paths: {
            jquery: '../../lib/jquery/dist/jquery.min',
            // keep the old version of angular for comparison and debugging purposes
            // angular: '../../lib/angular/angular',
            angular: '../../lib/angular130/angular',
            ngAnimate: '../../lib/angular-animate/angular-animate.min',
            ngTouch: '../../lib/angular-touch/angular-touch.min',
            'ng-table': '../../lib/ng-table/ng-table',
            //'bootstrap': '../../lib/bootstrap/dist/js/bootstrap',
            'angular-strap': '../../lib/angular-strap/dist/angular-strap',
            'angular-tooltip': '../../lib/angular-strap/dist/modules/tooltip.min',
            'angular-parse-options':
                '../../lib/angular-strap/dist/modules/parse-options',
            //'angular-date-parser': '../../lib/angular-strap/dist/modules/date-parser.min',
            'angular-bootstrap-slider': '../../lib/angular-bootstrap-slider/slider',
            'angular-strap.tpl': '../../lib/angular-strap/dist/angular-strap.tpl',
            translate: '../../lib/angular-translate/angular-translate',
            'translate-static-loader':
                '../../lib/angular-translate-loader-static-files/angular-translate-loader-static-files',
            'angular-translate-loader-partial':
                '../../lib/angular-translate-loader-partial/angular-translate-loader-partial.min',
            'translate-handler-log':
                '../../lib/angular-translate-handler-log/angular-translate-handler-log',
            'angular-route': '../../lib/angular-route/angular-route',
            textAngular: '../../lib/textAngular/dist/textAngular.min',
            textAngularsanistize:
                '../../lib/textAngular/dist/textAngular-sanitize.min',
            textAngularrangy: '../../lib/textAngular/dist/textAngular-rangy.min',
            'angular-form-builder':
                '../../lib/angular-form-builder/dist/angular-form-builder',
            'angular-form-builder-components':
                '../../lib/angular-form-builder/dist/angular-form-builder-components',
            'angular-validator': '../../lib/angular-validator/dist/angular-validator',
            'angular-validator-rules':
                '../../lib/angular-validator/dist/angular-validator-rules',
            /*'angular-animate': '../../lib/angular-animate/angular-animate',*/
            //'ngDraggable' : '../../lib/ngdraggable/ngdraggable',
            /*'ol3js': '../../lib/ol3/build/ol3.3',*/
            //'ol3js': '../../lib/ol36/ol',
            ol3js: '../../lib/ol401/ol-debug',
            kisoljs: 'widgets/mapapp/map/directives/KISTileArcGISRest',
            kisprojjs: 'widgets/mapapp/map/directives/KISLoadedProjections',
            olexjs: '../../lib/openlayers-ext/dist/ol-ext',
            swall: '../../lib/sweetalert/dist/sweetalert.min',
            //'ol3cesium': '../../lib/ol3-cesium/ol3cesium',
            //'cesium': '../../lib/ol3-cesium/Cesium/Cesium',
            'angular-toggle-switch':
                '../../lib/angular-toggle-switch/angular-toggle-switch',
            'angular-cookies': '../../lib/angular-cookies/angular-cookies.min',
            'angular-resource': '../../lib/angular-resource/angular-resource.min',
            ngSanitize: '../../lib/angular-sanitize/angular-sanitize.min',
            ngCsv: '../../lib/ng-csv/build/ng-csv.min',

            'angular-bootstrap-nav-tree':
                '../../lib/angular-bootstrap-nav-tree/dist/abn_tree_directive',
            ngBonita: '../../lib/ng-bonita/dist/ngBonita-min',
            ngProgress: '../../lib/ngProgress/build/ngprogress.min',
            colpick: '../../lib/colpick/colpick',
            toastr: '../../lib/toastr/toastr',
            ngDialog: '../../lib/ngDialog/js/ngDialog',
            ngMock: '../../lib/angular-mocks/angular-mocks',
            ngDragDrop: '../../lib/angular-native-dragdrop/draganddrop',
            tmhDynamicLocale: '../../lib/ngLocale/tmhDynamicLocale',
            ngLocale:
                '../../lib/ngLocale/angular-locale_' +
                localStorage.getItem('current_language'),
            // 'ngLocale': '../../lib/ngLocale/angular-locale_fr',
            x2js: '../../lib/angular-x2js-master/xml2json',
            'cb.x2js': '../../lib/angular-x2js-master/src/x2js',
            'colorpicker.module':
                '../../lib/angular-bootstrap-colorpicker-master/js/bootstrap-colorpicker-module',
            'ui-rangeSlider':
                '../../lib/angular-rangeslider-master/angular.rangeSlider',
            'cfp.hotkeys': '../../lib/angular-hotkeys/build/hotkeys.min',
            chartist: '../../lib/chartist/chartist.min',
            dropzone: '../../lib/dropzone/dist/dropzone',
            easel: '../../lib/easel/easeljs-0.8.1.min',
            dragula: '../../lib/dragula/dragula',
            xeditable: '../../lib/angular-xeditable/dist/js/xeditable.min',
            h5utils: '../../lib/tierce/h5utils',
            d3: '../../lib/d3/d3',
            nvd3: '../../lib/nvd3/build/nv.d3',
            proj4: '../../lib/proj4/dist/proj4',
            'angular-nvd3-directives':
                '../../lib/angularjs-nvd3-directives/dist/angularjs-nvd3-directives',
            'angular-nvd3': '../../lib/angular-nvd3/dist/angular-nvd3',
            spectrum: '../../lib/bgrins-spectrum/spectrum',
            //'w11k-flash': '../../lib/w11k-flash/dist/js/w11k-flash',
            //'w11k-flash.tpl': '../../lib/w11k-flash/dist/js/w11k-flash.tpl',
            dndlist:
                '../../lib/angular-drag-and-drop-lists/angular-drag-and-drop-lists',
            'angular-calendar':
                '../../lib/angular-calendar/dist/js/calendar-tpls.min',
            'angular-ui-calendar': '../../lib/angular-ui-calendar/src/calendar',
            'full-calendar': '../../lib/fullcalendar/dist/fullcalendar.min',
            moment: '../../lib/moment/min/moment.min',
            'context-menu': '../../lib/angular-contextmenu/contextmenu',
            'angular-recursion': '../../lib/angular-recursion/angular-recursion.min',
            mdChips: '../../lib/md-chips/mdchips',
            papaparse: '../../lib/papaparse/papaparse.min',
            socialshare: '../../lib/angular-socialshare/angular-socialshare.min',
            'angular-bind-html-compile':
                '../../lib/angular-bind-html-compile/angular-bind-html-compile',
            signature_pad: '../../lib/signature_pad/signature_pad',
            'angular-jsoneditor':
                '../../lib/angular-jsoneditor/dist/angular-jsoneditor',
            'ui.select': '../../lib/angular-ui-select/select.min',
            'ui.multiselect': '../../lib/angular-ui-multiselect/multiselect',
            string_score: '../../lib/string_score/string_score',
            'ui-grid': '../../lib/angular-ui-grid/ui-grid.min',
            'ui-grid-custom-cell-select':
                '../../lib/ui-grid-custom-cell-select/js/custom-cell-select',
            CSV: '../../lib/csv-js/csv',
            vkbeautify: '../../lib/vkbeautify/vkbeautify',
        },
        shim: {
            colpick: { deps: ['jquery'] },
            angular: {
                deps: ['jquery'],
                exports: 'angular',
            },
            ngAnimate: {
                deps: ['angular'],
            },
            ngTouch: {
                deps: ['angular'],
            },
            'angular-route': {
                deps: ['angular'],
            },
            'angular-cookies': {
                deps: ['angular'],
            },
            'angular-resource': {
                deps: ['angular'],
            },
            'angular-bootstrap-slider': {
                deps: ['angular'],
            },
            ngSanitize: {
                deps: ['angular'],
            },
            'ng-table': {
                deps: ['angular-route'],
            },
            translate: {
                deps: ['angular'],
            },
            'translate-static-loader': {
                deps: ['translate'],
            },
            'angular-translate-loader-partial': {
                deps: ['translate'],
            },
            'translate-handler-log': {
                deps: ['translate'],
            },
            'angular-strap': {
                deps: ['angular'],
            },
            'angular-strap.tpl': {
                deps: ['angular-strap'],
            },
            'angular-tooltip': {
                deps: ['angular-strap'],
            },
            ngDraggable: {
                deps: ['angular'],
            },

            textAngular: {
                deps: ['angular'],
            },
            textAngularsanistize: {
                deps: ['angular'],
            },
            textAngularrangy: {
                deps: ['angular'],
            },
            'angular-validator': {
                deps: ['angular'],
            },
            'angular-validator-rules': {
                deps: ['angular-validator'],
            },
            'angular-form-builder': {
                deps: ['angular'],
            },
            'angular-form-builder-components': {
                deps: ['angular-form-builder', 'angular-validator'],
            },

            'angular-parse-options': {
                deps: ['angular-strap'],
            },

            ngCsv: {
                deps: ['ngSanitize'],
            },
            /*'ol3cesium': {
                   deps: ['cesium','ol3js']
                   },*/
            kisoljs: {
                deps: ['ol3js'],
            },
            kisprojjs: {
                deps: ['proj4'],
            },
            'angular-toggle-switch': {
                deps: ['angular'],
            },
            'angular-bootstrap-nav-tree': {
                deps: ['angular-toggle-switch'],
            },
            ngBonita: {
                deps: ['angular-toggle-switch'],
            },
            ngProgress: {
                deps: ['angular'],
            },
            ngDialog: {
                deps: ['angular'],
            },
            ngMock: {
                deps: ['angular']
            },
            ngDragDrop: {
                deps: ['angular'],
            },
            'cb.x2js': {
                deps: ['angular', 'x2js'],
            },
            'colorpicker.module': {
                deps: ['angular'],
            },
            'ui-rangeSlider': {
                deps: ['ngTouch'],
            },
            'cfp.hotkeys': {
                deps: ['angular'],
            },
            tmhDynamicLocale: {
                deps: ['angular'],
            },
            ngLocale: {
                deps: ['angular'],
            },
            xeditable: {
                deps: ['angular'],
            },
            d3: { exports: 'angular' },
            nvd3: {
                deps: ['angular', 'd3'],
            },
            'angular-nvd3-directives': {
                deps: ['angular', 'nvd3'],
            },
            'angular-nvd3': {
                deps: ['angular', 'nvd3'],
            },
            spectrum: {
                deps: ['jquery'],
            },
            /*'w11k-flash': {
                   deps: ['angular']
                   },
                   'w11k-flash.tpl': {
                   deps: ['angular']
                   },*/

            dndlist: {
                deps: ['angular'],
            },
            'angular-calendar': {
                deps: ['angular'],
            },
            'angular-ui-calendar': {
                deps: ['angular'],
            },
            'full-calendar': {
                deps: ['jquery', 'angular', 'moment'],
            },

            'context-menu': {
                deps: ['angular'],
            },

            'angular-recursion': {
                deps: ['angular'],
            },
            mdChips: {
                deps: ['angular'],
            },
            socialshare: {
                deps: ['angular'],
            },
            'angular-bind-html-compile': {
                deps: ['angular'],
            },
            signature_pad: {},
            'angular-jsoneditor': {
                deps: ['angular'],
            },
            string_score: {
                deps: [],
            },
            'ui.select': {
                deps: ['angular', 'ngSanitize'],
            },
            'ui.multiselect': {
                deps: ['angular'],
            },
            'ui-grid': {
                deps: ['angular', 'jquery', 'CSV'],
            },
            'ui-grid-custom-cell-select': {
                deps: ['angular', 'jquery', 'CSV', 'ui-grid'],
            },
            vkbeautify: {
                deps: [],
            },
            olexjs: {
                deps: ['ol3js'],
            }
        },

        // ask Require.js to load these files (all our tests)
        deps: tests,

        /// @RB Moved into the callback to the require init (end of file)
        // start test run, once Require.js is done
        //callback: window.__karma__.start
    });

    requirejs([
            'swall',
            'ol3js',
            'proj4',
            'moment',
            'CSV',
            'kisoljs',
            'kisprojjs',
            'vkbeautify',
            'string_score',
            'ui-grid',
            'ui-grid-custom-cell-select',
            // **************************************************************************************************
            // PLEASE ORDER THOSE  IN THE SAME ORDER AS IN js/XG/modules/configuration/constant/configuration.js
            // Or it becomes really hard to debug dependencies problems
            // **************************************************************************************************

            //CONTAINER
            'containers/mod',
            //CORE
            'modules/configuration/mod',
            'modules/common/mod',

            'modules/export/mod',
            'modules/geometry/mod',
            'modules/googlemaps/mod',
            'modules/query/mod',
            'modules/majic/mod',
            'modules/config/mod',
            'modules/edit/mod',
            'modules/ogc/mod',
            'modules/report/mod',
            'modules/featureattachment/mod',
            'modules/file/mod',
            'modules/authentication/mod',
            'modules/home/mod',
            'modules/translations/mod',
            'modules/licence/mod',
            'modules/portals/mod',
            'modules/root/mod',
            'modules/rights/mod',
            'modules/model/mod',
            'modules/tools/mod',
            'modules/applications/mod',
            'modules/dbparameters/mod',
            'modules/graticules/mod',
            'modules/logtracker/mod',
            'modules/dolibarr/mod',
            'modules/print/mod',
            'modules/ogc/mod',
            'modules/odk/mod',
            'modules/process/mod',
            'modules/function/mod',
            'modules/style/mod',
            'modules/interfaces/mod',

            //UTILITIES
            'widgets/utilities/model/mod',
            'widgets/utilities/edit/mod',
            'widgets/utilities/data/mod',
            'widgets/utilities/select/mod',
            'widgets/utilities/form/mod',
            'widgets/utilities/html/mod',
            'widgets/utilities/report/mod',
            'widgets/utilities/component/mod',
            'widgets/utilities/config/mod',
            'widgets/utilities/calculateurExpression/mod',
            'widgets/utilities/chart/mod',
            'widgets/utilities/network/mod',
            'widgets/utilities/calendar/mod',
            'widgets/utilities/elastic/mod',
            'widgets/utilities/statsAffaires/mod',
            'widgets/utilities/getAndSaveTemplates/mod',
            'widgets/utilities/itv/mod',
            'widgets/utilities/dbParamInfo/mod',
            'widgets/utilities/relations/mod',

            //MAP APP
            'widgets/mapapp/main/mod',
            'widgets/mapapp/config/mod',
            'widgets/mapapp/geolocation/mod',
            'widgets/mapapp/measure/mod',
            'widgets/mapapp/selectiontools/mod',
            //'widgets/mapapp/layerManager/mapmodel/mod',
            'widgets/mapapp/layerManager/mod',
            'widgets/mapapp/scalevalue/mod',
            'widgets/mapapp/mouseposition/mod',
            'widgets/mapapp/map/mod',
            'widgets/mapapp/scaleline/mod',
            'widgets/mapapp/gcstyles/mod',
            'widgets/mapapp/importwms/mod',
            'widgets/mapapp/importwfs/mod',
            'widgets/mapapp/openweathermap/mod',
            'widgets/mapapp/selectmanager/mod',
            'widgets/mapapp/selecttool/mod',
            'widgets/mapapp/selecttoolbypoint/mod',
            'widgets/mapapp/extractcoordinates/mod',
            'widgets/mapapp/selecttoolbypointutilities/mod',
            'widgets/mapapp/selecttoolbypolygon/mod',
            'widgets/mapapp/selecttoolbyline/mod',
            'widgets/mapapp/selecttoolbuffer/mod',
            'widgets/mapapp/print/mod',
            'widgets/mapapp/printv2/mod',
            'widgets/mapapp/atlas/mod',
            'widgets/mapapp/exportgeopackage/mod',
            'widgets/mapapp/importExportMBTILES/mod',
            //'widgets/mapapp/3DCesium/mod',
            'widgets/mapapp/streetview/mod',
            'widgets/mapapp/geocoderreverse/mod',
            'widgets/mapapp/geocoderreversew3w/mod',
            'widgets/mapapp/style/mod',
            'widgets/mapapp/directions/mod',
            'widgets/mapapp/elevation/mod',
            'widgets/mapapp/basemap/mod',
            'widgets/mapapp/position/mod',
            'widgets/mapapp/what3words/mod',
            'widgets/mapapp/ExecutQueryTest/mod',
            'widgets/mapapp/maphistoric/mod',
            'widgets/mapapp/edition/mod',
            'widgets/mapapp/getwmswfs/mod',
            'widgets/mapapp/bizedition/mod',
            'widgets/mapapp/exportmap/mod',
            'widgets/mapapp/exportmapsvg/mod',
            'widgets/mapapp/majic/mod',
            'widgets/mapapp/geosignet/mod',
            'widgets/mapapp/versionlib/mod',
            'widgets/mapapp/importexport/mod',
            'widgets/mapapp/importdxf/mod',
            'widgets/mapapp/importdwg/mod',
            'widgets/mapapp/importdivers/mod',
            'widgets/mapapp/indigau/mod',
            'widgets/mapapp/mapcatalog/mod',
            'widgets/mapapp/esriprint/mod',
            'widgets/mapapp/wflow/mod',
            'widgets/mapapp/query/mod',
            'widgets/mapapp/selectFeatureTree/mod',
            'widgets/mapapp/geolocalisation/mod',
            'widgets/mapapp/anc/mod',
            'widgets/mapapp/simpleIntervention/mod',
            'widgets/mapapp/legend/mod',
            'widgets/mapapp/staticImage/mod',
            'widgets/mapapp/longitudinalprofile/mod',
            'widgets/mapapp/takephoto/mod',
            'widgets/mapapp/overview/mod',
            'widgets/mapapp/annotations/mod',
            'widgets/mapapp/mapannotations/mod',
            'widgets/mapapp/defaultfilters/mod',
            'widgets/mapapp/interventionflow/mod',
            'widgets/mapapp/majic/mod',
            'widgets/mapapp/dict/mod',
            'widgets/mapapp/network/mod',
            'widgets/mapapp/statistiques/mod',

            //'widgets/mapapp/itv/mod',
            'widgets/mapapp/LITV/mod',
            'widgets/mapapp/dashboard/mod',
            'widgets/mapapp/tabledata/mod',
            'widgets/mapapp/quickfilter/mod',
            'widgets/mapapp/quickquery/mod',
            'widgets/mapapp/quickpopup/mod',
            'widgets/mapapp/iframewidget/mod',
            'widgets/mapapp/geotreatment/mod',
            'widgets/mapapp/customforms/mod',
            'widgets/mapapp/example1/mod',
            'widgets/mapapp/about/mod',
            'widgets/mapapp/featureattachment/mod',
            'widgets/mapapp/elasticsearch/mod',
            'widgets/mapapp/dynamicstyle/mod',
            'widgets/mapapp/urlsharing/mod',
            'widgets/mapapp/csvgeocoder/mod',
            'widgets/mapapp/rastercalage/mod',
            'widgets/mapapp/statistiques/mod',
            //'widgets/mapapp/operisconnect/js/AC_OETags',
            'widgets/mapapp/operisconnect/mod',

            // ASS
            'biz/ass/mod',
            //AEP
            'biz/aep/mod',
            'biz/aepInterventions/mod',
            //ANC
            'biz/anc/mod',
            //'biz/ass/mod',
            // Tierces
            'widgets/mapapp/tiercewidget/mod',

            // YAMOU
            'biz/yamoussoukro/widgets/cherchermodsup/mod',
            'biz/yamoussoukro/widgets/chercherconsult/mod',
            'biz/yamoussoukro/widgets/editobjectwidget/mod',
            'biz/yamoussoukro/modules/form/tableselectandupdate/mod',
            'biz/yamoussoukro/widgets/searchresult/mod',
            'biz/yamoussoukro/modules/form/globalservices/mod',
            'biz/yamoussoukro/modules/tools/gcesendmail/mod',
            'biz/yamoussoukro/modules/form/formfield/mod',
            'biz/yamoussoukro/modules/form/intervalfield/mod',
            'biz/yamoussoukro/modules/form/ffl2/mod',
            'biz/yamoussoukro/modules/form/ffpl2/mod',
            'biz/yamoussoukro/modules/form/ffgl2/mod',
            'biz/yamoussoukro/modules/form/fftablel2/mod',
            'biz/yamoussoukro/modules/form/fftable4updl2/mod',
            'biz/yamoussoukro/modules/form/ffl2attachment/mod',
            'biz/yamoussoukro/modules/form/relationformfield/mod',
            'biz/yamoussoukro/modules/form/relationformfieldl2/mod',
            'biz/yamoussoukro/modules/form/reportfield/mod',
            'biz/yamoussoukro/modules/form/formfieldgroup/mod',
            'biz/yamoussoukro/modules/form/formfieldpanel/mod',
            'biz/yamoussoukro/modules/form/sendmailfield/mod',
            'biz/yamoussoukro/modules/form/stepcontainer/mod',
            'biz/yamoussoukro/modules/form/tabcontainer/mod',
            'biz/yamoussoukro/modules/form/containercontainer/mod',
            'biz/yamoussoukro/modules/form/objlistcontainer/mod',
            'biz/yamoussoukro/modules/form/applyprocedure/mod',
            'biz/yamoussoukro/modules/form/units/mod',
            'biz/yamoussoukro/modules/form/geometryfield/mod',
            'biz/yamoussoukro/modules/form/indicateurmgt/mod',
            'biz/yamoussoukro/widgets/typeprojet/mod',
            'biz/yamoussoukro/widgets/choixprogramme/mod',
            'biz/yamoussoukro/modules/form/containercontainer/mod',
            'biz/yamoussoukro/modules/form/objlistcontainer/mod',

            /**
             * SEPPRI (HPO)
             */
            'widgets/hpoapp/home_admin_data/mod',
            'widgets/hpoapp/model/mod',
            'widgets/hpoapp/analye_multicritere/mod',
            'widgets/hpoapp/chantiers/mod',
            'widgets/hpoapp/main/mod',

            //TOOLS
            'tools/UrlUtils',
            'tools/GeneralFactory',
            'tools/BrowserSniffer',
            'tools/gcDirectivesList',
            'tools/jsUtils',
            'tools/featureGeometryEditor',
            'tools/domUtils',
            'tools/TierceFunctions',
            'tools/RestrictionsProvider',
            'tools/mapUtils',
            // **************************************************************************************************
            // **************************************************************************************************

            //FORM APP
            'widgets/formapp/main/mod',
            'widgets/indigauapp/main/mod',

            // SIROCO
            'widgets/sirocoapp/main/mod',
            'widgets/sirocoapp/init/mod',
            'widgets/sirocoapp/export/mod',

            // ANC APP
            'widgets/ancapp/main/mod',

            // BAC APP
            'widgets/bacapp/main/mod',

            'angular-route',
            'angular-toggle-switch',

            'angular-bootstrap-nav-tree',
            'angular-bootstrap-slider',
            'ng-table',
            //'bootstrapdropdown',
            'ngDialog',
            'ngMock',
            'tmhDynamicLocale',
            'ngLocale',
            'ngBonita',
            'ngProgress',
            'ui-rangeSlider',
            'textAngular',
            'textAngularsanistize',
            'textAngularrangy',
            'dropzone',
            'xeditable',
            'ngDragDrop',
            'colpick',
            'spectrum',
            'easel',
            'dragula',
            'cfp.hotkeys',
            'translate',
            'translate-static-loader',
            'angular-translate-loader-partial',
            'translate-handler-log',
            //'angular-date-parser',
            'angular-parse-options',
            'angular-parse-options',
            'angular-tooltip',
            'angular-cookies',
            'angular-resource',
            'ngSanitize',
            'ngCsv',
            'ngAnimate',
            //'w11k-flash',
            //'w11k-flash.tpl',
            'dndlist',
            'angular-calendar',
            'angular-ui-calendar',
            'full-calendar',
            'angular-recursion',
            //TOOLS
            'jquery',
            /*'bootstrap',*/
            //'ngdraggable',
            /*'tools/UrlUtils',
                     'tools/BrowserSniffer',*/
            'angular-validator',
            'angular-validator-rules',
            'angular-form-builder',
            'angular-form-builder-components',
            'd3',
            'h5utils',
            'context-menu',
            'nvd3',
            'angular-nvd3-directives',
            'angular-nvd3',
            'mdChips',
            'socialshare',
            'angular-bind-html-compile',
            'angular-jsoneditor',
            'ui.select',
            'ui.multiselect',
            'papaparse',
            //'cesium',
            //'ol3cesium',
            'chartist',
            'angular',
            'app',
        ],
        function (swal, ol, proj4, moment, CSV) {
            window.ol = ol;
            require(['olexjs']);
            window.proj4 = proj4;
            window.moment = moment;
            window.CSV = CSV;
            window.CSV.DETECT_TYPES = true;
            olkis.deployInherits();
            olkis.loadProjections();
            angular.bootstrap(document, ['app'], { strictDi: true });

            /// @RB Moved into the callback to the require init (end of file)
            window.__karma__.start();
        });

}(require));