'use strict';
define(function() {
  var gcshapeimport = function(
    ImportExportFactory,
    FeatureTypeFactory,
    DataStoreFactory,
    $translate,
    $q,
    SridFactory,
    $filter,
    gaJsUtils
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/model/views/gcshapeimport.html',
      restrict: 'AE',
      scope: {
        stores: '=',
      },
      link: function(scope) {
        scope.destinationSRID = null;
        scope.srids = SridFactory.sridsList;
        scope.uploadProcessID = -1;
        scope.importedFeatures = [];

        scope.selectedStore = null;

        scope.srcsrid = '';

        scope.importData = true;

        scope.waitImport = false;

        var confirmLabel = 'Import avec succès';

        $translate('model.featuretypes.import_shape.confirmMsg').then(function(
          res
        ) {
          confirmLabel = res;
        });

        var errorLabel = "Erreur d'import!";

        $translate('model.featuretypes.import_shape.error').then(function(res) {
          errorLabel = res;
        });

        /**
         * [importFile description]
         * @return {[type]} [description]
         */
        scope.importFile = function() {
          if (scope.dropzoneComponent.files.length > 0) {
            ImportExportFactory.loadSchema(scope.uploadProcessID).then((importResult)=> {
              scope.importedFeatures = [];
              importResult.data.forEach(imp => {
                if(gaJsUtils.checkCustomRegex(imp.name)){
                  const notAuthorizedAttributes = imp.attributes.filter(att => !gaJsUtils.checkCustomRegex(att.name));
                  if(notAuthorizedAttributes.length>0){
                    const attributesJoined = notAuthorizedAttributes.map(att => att.name).join(', ');
                    require('toastr').error(imp.name+": "+ 
                        $filter('translate')('model.featuretypes.attributes.forbiddenCharactersInAttributes').
                          replace("$1",attributesJoined));
                  }else{
                    scope.importedFeatures.push(imp);
                  }
                }else{
                  require('toastr').error(imp.name+": "+
                        $filter('translate')('model.featuretypes.attributes.forbidden_characters'));
                }
              })
            });
          }
        };

        /**
         * [clearDropzone description]
         * @return {[type]} [description]
         */
        scope.clearDropzone = function() {
          if (scope.dropzoneComponent.files.length > 0) {
            scope.dropzoneComponent.removeAllFiles();

            scope.importedFeatures = [];
          }
        };

        function addTableAndLoadData(i) {
          var defer = $q.defer();
          var promises = [];
          promises.push(defer.promise);
          var currentImportFTI = scope.importFT;
          var p = DataStoreFactory.addtable(
            scope.selectedStore.name,
            currentImportFTI,
            scope.destinationSRID,
            scope.forceUpdateAttributsAndSrid
          ).then(
            function(res) {
              if (res.data !== '') {
                var newFti = res.data;
                var p2 = FeatureTypeFactory.add(newFti).then(
                  function(addRes) {
                    if (scope.importData) {
                      var addFti = addRes.data;
                      var destFeatureType = addFti.uid;
                      scope.srcsrid = currentImportFTI.srid;
                      var strAttrCorrespArray = '';
                      var p3 = ImportExportFactory.loadandprojectdata(
                        scope.uploadProcessID,
                        scope.sourceFeatureType,
                        destFeatureType,
                        strAttrCorrespArray,
                        scope.srcsrid,
                        scope.destinationSRID
                      ).then(() =>{
                          reloadOrResolvePromise(i,promises,defer,'success');
                        },() =>{
                          reloadOrResolvePromise(i,promises,defer,'error');
                        }
                      );
                      promises.push(p3);
                    } else {
                      reloadOrResolvePromise(i,promises,defer,'success');
                    }
                  },() => {
                    reloadOrResolvePromise(i,promises,defer,'error');
                  }
                );
                promises.push(p2);
              } else {
                require('toastr').error(currentImportFTI.name+$filter('translate')('model.featuretypes.import_shape.tableExistInDB'));
                reloadOrResolvePromise(i,promises,defer,'error');
              }
            },(err) => {
              //message spécifique en cas d'erreur!
              if(err.data && err.data.message){
                if(err.data.message.startsWith('kis_error')){
                  require('toastr').error(currentImportFTI.name+$filter('translate')(
                    ('model.featuretypes.import_shape.'+err.data.message.split(':')[1])));
                }else{
                  require('toastr').error(err.data.message);
                }
              }
              reloadOrResolvePromise(i,promises,defer, 'error');
            }
          );
          promises.push(p);
          return $q.all(promises);
        }

        let reloadOrResolvePromise = (i, promises, defer,toastr) =>{
          i = i + 1;
          if (
            scope.importedFeatures.length > 0 &&
            i <= scope.importedFeatures.length - 1
          ) {
            scope.importFT = scope.importedFeatures[i];
            scope.sourceFeatureType = scope.importFT.name;
            var p1 = addTableAndLoadData(i);
            promises.push(p1);
          } else {
            scope.waitImport = false;
            if(toastr==='error'){
              require('toastr').error(errorLabel);
            }else if(toastr ==='success'){
              require('toastr').success(confirmLabel);
            }
            scope.clearDropzone();
            defer.resolve('termine');
          }
        }

        /**
         * [submitShapeFeaturesImport description]
         * @return {[type]} [description]
         */
        scope.submitShapeFeaturesImport = function() {
          scope.waitImport = true;
          if (scope.selectedStore !== null) {
            var i = 0;
            if (
              scope.importedFeatures.length > 0 &&
              i <= scope.importedFeatures.length - 1
            ) {
              scope.importFT = scope.importedFeatures[i];
              scope.sourceFeatureType = scope.importFT.name;
              addTableAndLoadData(i);
            }
          }
        };
      },
    };
  };

  gcshapeimport.$inject = [
    'ImportExportFactory',
    'FeatureTypeFactory',
    'DataStoreFactory',
    '$translate',
    '$q',
    'SridFactory',
    '$filter',
    'gaJsUtils'
  ];
  return gcshapeimport;
});
