'use strict';
define(function() {
  var GeoserverFactory = function($http) {
    var GeoserverFactory = {};
    /**
     * Class : GeoserverFactory
     * Factory WebServices
     */

    /**
     * Function: removelayergroup
     */
    function removelayergroup(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geoserver/removeLayerGroup?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: getlayerconf
     */
    function getlayerconf(layerName) {
      var promise = $http.get(
        '/services/{portalid}/geoserver/getLayerConf?f=json' +
          '&layerName=' +
          layerName
      );

      return promise;
    }
    /**
     * Function: getlayergroupconfig
     */
    function getlayergroupconfig(layergroupname) {
      var promise = $http.get(
        '/services/{portalid}/geoserver/getLayersFromGroup?f=json' +
          '&layergroupname=' +
          layergroupname
      );

      return promise;
    }
    /**
     * Function: addlayerstolayergroup
     */
    function addlayerstolayergroup(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geoserver/updateLayerGroup?f=json',
        senddata
      );

      return promise;
    }
    /**
     * Function: changelayergroupdestination
     */
    function changelayergroupdestination(
      layerName,
      layerGroupNameSource,
      layerGroupNameDestination
    ) {
      var promise = $http.get(
        '/services/{portalid}/geoserver/changeLayerGroupDestination?f=json' +
          '&layerName=' +
          layerName +
          '&layerGroupNameSource=' +
          layerGroupNameSource +
          '&layerGroupNameDestination=' +
          layerGroupNameDestination
      );

      return promise;
    }
    /**
     * Function: removelayerfromlayergroup
     */
    function removelayerfromlayergroup(layerName, layerGroupName) {
      var promise = $http.get(
        '/services/{portalid}/geoserver/removeLayerFromLayerGroup?f=json' +
          '&layerName=' +
          layerName +
          '&layerGroupName=' +
          layerGroupName
      );

      return promise;
    }
    /**
     * Function: addlayertolayergroup
     */
    function addlayertolayergroup(layerName, layerGroupName) {
      var promise = $http.get(
        '/services/{portalid}/geoserver/addLayerToLayerGroup?f=json' +
          '&layerName=' +
          layerName +
          '&layerGroupName=' +
          layerGroupName
      );

      return promise;
    }
    /**
     * Function: getlayergroups
     */
    function getlayergroups() {
      var promise = $http.get(
        '/services/{portalid}/geoserver/getLayerGroups?f=json'
      );

      return promise;
    }
    /**
     * Function: addlayergroup
     */
    function addlayergroup(senddata) {
      var promise = $http.post(
        '/services/{portalid}/geoserver/addGroupLayer?f=json',
        senddata
      );

      return promise;
    }
    return {
      GeoserverFactory: GeoserverFactory,
      removelayergroup: removelayergroup,
      getlayerconf: getlayerconf,
      getlayergroupconfig: getlayergroupconfig,
      addlayerstolayergroup: addlayerstolayergroup,
      changelayergroupdestination: changelayergroupdestination,
      removelayerfromlayergroup: removelayerfromlayergroup,
      addlayertolayergroup: addlayertolayergroup,
      getlayergroups: getlayergroups,
      addlayergroup: addlayergroup,
    };
  };
  GeoserverFactory.$inject = ['$http'];
  return GeoserverFactory;
});
