'use strict';
define(function () {
  const setCountFromCollectionFunction = function () {

    /**
     * Retourne le nombre d'objets du tableau features en valeur numérique ou en texte selon le type de l'attribut de destination
     * @param features tableau de features geojson
     * @param targetAttributeType type de l'attribut de fti (ex. 'java.lang.Integer')
     * @return {string|number} longueur du tableau features en entier ou en string
     */
    const addCountByAttrType = (features, targetAttributeType) => {
      return targetAttributeType === 'java.lang.String' ? String(features.length)
          : features.length;
    };

    this.$get = function ($q, $filter, FeatureTypeFactory, gaJsUtils) {
      return {
        getParametersDesc: () => {
          return [
            [0, 'variable'],
            [1, 'variable'],
            [2, 'fti']
          ];
        },
        countDataFromCollection: (variables, ftiOfCurrent, destination, source, ftiToCountUid) => {
          const def = $q.defer();
          if (ftiOfCurrent && Array.isArray(ftiOfCurrent.attributes)) {
            if (destination.includes('.') && destination.split('.').length > 2 && ftiOfCurrent && Array.isArray(ftiOfCurrent.attributes)) {
              const destinationArray = destination.split('.');
              const targetAttributeName = destinationArray.pop();
              const targetProperties = destinationArray.pop();
              const targetVariable = destinationArray.pop();
              const targetAttribute = ftiOfCurrent.attributes.find(attr => attr.name === targetAttributeName);
              // le champ destination peut être numérique ou texte mais ni booleen ni date
              const forbiddenTypes = ['java.lang.Boolean', 'java.util.Date', 'java.sql.Timestamp'];
              if (targetAttribute !== undefined && !forbiddenTypes.includes(targetAttribute.type)) {

                const sourceVarHasFeatures = gaJsUtils.notNullAndDefined(variables[source], 'features')
                    && variables[source].features.length > 0;
                const targetPropertiesExists = gaJsUtils.notNullAndDefined(variables[targetVariable],
                    targetProperties);

                if (sourceVarHasFeatures && ftiToCountUid.length > 0 && targetPropertiesExists) {
                  const toCountFeaturesFti = FeatureTypeFactory.getFeatureByUid(ftiToCountUid);
                  if (toCountFeaturesFti) {
                    // filtre les features ayant un id contenant le nom du fti des objets à compter
                    const toCountFeatures = variables[source].features.filter(
                        feature => feature.id.split('.')[0] === toCountFeaturesFti.name);
                    // assigne toCountFeatures.length au champ de destination (soit string soit numérique)
                    variables[targetVariable][targetProperties][targetAttributeName] = addCountByAttrType(
                        toCountFeatures, targetAttribute.type);
                  } else {
                    // le fti n'existe pas dans les featuretypes de FeatureTypeFactory
                    // aucune feature ne correspond au composant paramétré alors le résultat à inscrire est 0.
                    variables[targetVariable][targetProperties][targetAttributeName] = addCountByAttrType(
                        [], targetAttribute.type);
                  }
                } else {
                  // aucune feature ne correspond au composant paramétré alors le résultat à inscrire est 0.
                  variables[targetVariable][targetProperties][targetAttributeName] = addCountByAttrType(
                      [], targetAttribute.type);
                }
              } else {
                // le champ de destination n'est pas conforme (type interdit pour la fonction)
                require('toastr').error($filter('translate')(
                    'functions_browser.functions.countDataFromCollection.error_configuration'));
              }
            } else {
              // la variable destination n'a pas un format égal à "current.properties.property"
              require('toastr').error($filter('translate')(
                  'functions_browser.functions.countDataFromCollection.error_configuration'));
            }
          } else {
            // si le fti fourni par formFieldRender et vide alors on ne peut pas déterminer le type de l'attribut de destination
            console.error('setDataFromCollection : ftiOfCurrent est vide ou null. ftiOfCurrent = ', ftiOfCurrent);
          }
          def.resolve();
          return def.promise;
        },
      };
    };

    this.$get.$inject = ['$q', '$filter', 'FeatureTypeFactory', 'gaJsUtils'];
  };
  return setCountFromCollectionFunction;
});