'use strict';
define(function() {
  var gcelement = function(
    editDirectivesProvider,
    selectDirectivesProvider,
    dataDirectivesProvider,
    htmlDirectivesProvider,
    reportDirectivesProvider,
    componentDirectivesProvider,
    networkDirectivesProvider,
    relationDirectivesProvider,
    $timeout,
    calendarDirectivesProvider,
    $rootScope,
    AssociationFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/formComponent.html',
      restrict: 'A',
      scope: {
        map: '=map',
        result: '=res',
        ftis: '=ftis',
        onvalidate: '&',
        treeControl: '=',
        dropped: '=',
        curtemplate: '=',
        hideGeometricComponents: '=?',
      },
      link: function(scope) {
        if (typeof scope.ftis != 'undefined') {
          scope.curfti = scope.ftis;
        }
        scope.$watch('ftis', function(f, oldF) {
          if (angular.isDefined(f) && f !== oldF) {
            console.log(scope.ftis);
            scope.curfti = scope.ftis;
          }
        });

        scope.goToDropField = function(node, index) {
          var goto = scope.dropped[node][index];
          scope.treeControl.select_branch(goto.branch);
          if (goto.tab != -1) {
            $timeout(function() {
              scope.curtemplate.activeTab = goto.tab;
            }, 0);
          }
        };

        let initTabs = function() {
          scope.tabs = [
            { title: 'tools.builder.components.tabs.attributes', id: 'attributes'},
            { title: 'tools.builder.components.tabs.selection', id: 'selection'},
            { title: 'tools.builder.components.tabs.data', id: 'data'},
            { title: 'tools.builder.components.tabs.html', id: 'html'},
            /* { "title" : "tools.builder.components.tabs.report"}, @RB temporary hidden since the components aren't ready */
            { title: 'tools.builder.components.tabs.items', id: 'items'},
            { title: 'tools.builder.components.tabs.calendar', id: 'calendar'},
            { title: 'tools.builder.components.tabs.relations', id: 'relations'},
            { title: 'tools.builder.components.tabs.associations', id: 'associations'},
          ];
          if (scope.hideGeometricComponents == false) {
            scope.tabs.splice(2,0,
              { title: 'tools.builder.components.tabs.edition', id: 'edition'});
              scope.tabs.splice(7,0,
                { title: 'tools.builder.components.tabs.network', id: 'network'});
          }
          scope.tabs.activeTab = 0;
        }
        scope.$watch('hideGeometricComponents', function() {
          initTabs()
        });
        initTabs();
        scope.filterAssociation = function (association) {
          if(scope.curfti && scope.curfti.name){
            return association.atable === scope.curfti.name || association.btable === scope.curfti.name; 
          }else{
            return [];
          }
        };

        if($rootScope.xgos.portal && $rootScope.xgos.portal.parameters && 
          $rootScope.xgos.portal.parameters.mainDB){
            AssociationFactory.getAll($rootScope.xgos.portal.parameters.mainDB).then((res) => {
              scope.associationsDirectives = res.data.filter(asso => !asso.type_patrimoine);
            });
        }

        /**
         * hide geometric components if needed
         * @param {*} component 
         * @returns true if the component should be displayed, false otherwise
         */
        scope.geometricComponents = (component) => {
          if (scope.hideGeometricComponents) {
            switch (scope.tabs[scope.tabs.activeTab].id) {
              case 'selection':
                // in 'selection' tab, only 'selectsearchdata' is not geometric
                return component.name === 'selectsearchdata';
              default:
                return true;
            }
          } else {
            return true;
          }
        };
        
        scope.editionDirectives = editDirectivesProvider.getDirectives();
        scope.selectionDirectives = selectDirectivesProvider.getDirectives();
        scope.dataDirectives = dataDirectivesProvider.getDirectives();
        scope.htmlDirectives = htmlDirectivesProvider.getDirectives();
        scope.reportDirectives = reportDirectivesProvider.getDirectives();
        scope.componentDirectives = componentDirectivesProvider.getDirectives();
        scope.networkDirectives = networkDirectivesProvider.getDirectives();
        scope.calendarDirectives = calendarDirectivesProvider.getDirectives();
        scope.relationDirectives = relationDirectivesProvider.getDirectives();

        scope.dropValidate = function(target, source) {
          return target !== source;
        };

      },
    };
  };

  gcelement.$inject = [
    'editDirectivesProvider',
    'selectDirectivesProvider',
    'dataDirectivesProvider',
    'htmlDirectivesProvider',
    'reportDirectivesProvider',
    'componentDirectivesProvider',
    'networkDirectivesProvider',
    'relationDirectivesProvider',
    '$timeout',
    'calendarDirectivesProvider',
    '$rootScope',
    'AssociationFactory',
  ];
  return gcelement;
});
