'use strict';
define(function() {
  var sldimagesymbolizer = function($location) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/style/views/symbolizer/sldimagesymbolizer.html',
      restrict: 'EA',
      scope: {
        graphic: '=graphic',
        fti: '=fti',
        allowzerominvalue: '=?',
        hideoffset: '=?',
        isannotation: '=?'
      },
      link: function(scope, elt, attrs, ctrl) {
        /**
         * set the image picked from the list
         * @param data
         */
        scope.setImage = data => {
          let type = 'image/png';

          if (~data.img.indexOf('.png')) type = 'image/png';
          if (~data.img.indexOf('.svg')) type = 'image/svg+xml';

          const prefix = scope.isannotation ? $location.protocol() + '://' + $location.host() : 'http://localhost';

          // Suite analyse dysfonctionnement https + annonay-rhone-agglo
          // http et non https car geoserver fonctionne en http
          // localhost car le proxypass fera la redirection si geoserver sur une autre machine
          scope.graphic.ExternalGraphic.OnlineResource._href =
            prefix +
            data.url +
            '/' +
            data.img;
          scope.graphic.ExternalGraphic.Format = type;
        };
      },
    };
  };

  sldimagesymbolizer.$inject = ['$location'];
  return sldimagesymbolizer;
});
