'use strict';
define([
  'angular',
  'widgets/mapapp/measure/services/MeasureFactory',
  'widgets/mapapp/measure/directives/measuretoolbarDirective',
  'widgets/mapapp/measure/directives/measureDirective',
  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'toastr',
  'ol3js',
  'ng-table',
], function(angular, MeasureFactory, measuretbDirective, measureDirective) {
  // generation du module
  var map_measure = angular.module('gc_measure', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
  ]);
  // ajout service
  map_measure.factory('MeasureFactory', MeasureFactory);

  // ajout controller

  // ajout directive
  // modelwidget.directive('gcmodelwidgetdir',gc_scalelinedirectives);
  map_measure.directive('toolbarmeasuredirective', measuretbDirective);
  //map_measure.directive('measuredirective',measureDirective);
  // ajout factory

  //route provider
  map_measure.filter('measure', function() {
    return function(floatInMeter, type, units) {
      // Type could be: volume, area or distance
      var factor = 1000;
      switch (type) {
        case 'volume':
          factor = Math.pow(factor, 3);
          break;
        case 'area':
          factor = Math.pow(factor, 2);
          break;
        default:
          break;
      }
      units = units || [' km', ' m'];
      floatInMeter = floatInMeter || 0;
      var measure = floatInMeter.toFixed(2);
      var km = Math.floor(measure / factor);

      if (km <= 0) {
        if (parseInt(measure) == 0) {
          measure = 0;
        }
        return measure + units[1];
      }

      var str = '' + km;
      var m = Math.floor(((Math.floor(measure) % factor) * 100) / factor);

      if (m > 0) {
        str += '.';
        if (m < 10) {
          str += '0';
        }
        str += m;
      }
      str += ' ' + units[0];
      return str;
    };
  });
  map_measure.filter('measure2', function() {
    return function(floatInMeter, type, units) {
      // Type could be: volume, area or distance
      var factor = 10000;
      switch (type) {
        case 'volume':
          factor = Math.pow(factor, 3);
          break;
        case 'area':
          factor = Math.pow(factor, 2);
          break;
        default:
          break;
      }
      units = units || [' km', ' m'];
      floatInMeter = floatInMeter || 0;
      var measure = floatInMeter.toFixed(2);
      var km = Math.floor(measure / factor);

      if (km <= 0) {
        if (parseInt(measure) == 0) {
          measure = 0;
        }
        return measure + units[1];
      }

      var str = '' + km;
      var m = Math.floor(((Math.floor(measure) % factor) * 100) / factor);

      if (m > 0) {
        str += '.';
        if (m < 10) {
          str += '0';
        }
        str += m;
      }
      str += ' ' + units[0];
      return str;
    };
  });
  return map_measure;
});
