'use strict';
define(function() {
  var toolbarmaphistoric = function($timeout) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/maphistoric/views/toolbarmaphistoric.html',
      restrict: 'A',

      link: function(scope, element, attrs, ctrl) {
        var map = scope.map;
        var mapView = map.getView();

        scope.currentViewIndex = -1;
        var recordedViews = [];
        var maxRecords = 20;
        scope.nextDisable = true;
        scope.previousDisable = true;

        var eventName = 'moveend';
        //var eventName = "propertychange";

        function updatePrevNextBtns() {
          if (recordedViews.length == 0) {
            scope.nextDisable = true;
            scope.previousDisable = true;
          } else {
            if (scope.currentViewIndex <= 0) {
              scope.previousDisable = true;
            } else {
              scope.previousDisable = false;
            }

            if (scope.currentViewIndex >= recordedViews.length - 1) {
              scope.nextDisable = true;
            } else {
              scope.nextDisable = false;
            }
          }
          try {
            scope.$apply(scope);
          } catch(err) {}
        }

        function recordNewView(e) {
          mapView = map.getView();
          var v = {
            zoom: mapView.getZoom(),
            center: mapView.getCenter(),
          };

          //                    if (recordedViews.length >= maxRecords){
          //                        //Suppression de la plus ancienne des vues située au début du tableau.
          //                        recordedViews.shift();
          //                    }
          //                    //Ajout de la vue à la fin du tableau des vues
          //                    recordedViews.push(v);
          //                     //Mise à jour de l'index de la vue courante
          //                    scope.currentViewIndex = recordedViews.length -1 ;
          //
          //Si l'index de la vue courante est déjà positionné sur la l'index maxi,
          // alors suppression de la première vue du tableau
          if (
            recordedViews.length >= maxRecords &&
            scope.currentViewIndex + 1 >= maxRecords
          ) {
            //Suppression de la plus ancienne des vues située au début du tableau.
            recordedViews.shift();
          }
          //Si l'index de la vue courante est situé sur un enregistrement qui n'est pas le dernier enregistrement,
          // alors suppression de toutes les vues d'index supérieur à l'index courant (la nouvelle vue qui va être enregistrée va se trouver juste après la vue courante
          else if (scope.currentViewIndex < recordedViews.length - 1) {
            recordedViews.splice(
              scope.currentViewIndex + 1,
              recordedViews.length - (scope.currentViewIndex + 1)
            );
          }
          //Ajout de la vue à la fin du tableau des vues
          recordedViews.push(v);
          //On se trouve alors forcement sur la dernière vue (currentindex = dernière vue)
          scope.currentViewIndex = recordedViews.length - 1;
          updatePrevNextBtns();
        }

        function addChangeListener() {
          // mapView.un(eventName,addChangeListener);
          map.on(eventName, recordNewView);
        }
        map.on(eventName, recordNewView);

        function setMapView(view) {
          if (view == undefined) return;
          //suppression de l'écouteur le temps du chargement de la vue
          map.un(eventName, recordNewView);
          mapView.setZoom(view.zoom);
          mapView.setCenter(view.center);
          //map.on(eventName,addChangeListener);
          $timeout(addChangeListener, 100);
        }

        scope.previousViewHandler = function(e) {
          if (recordedViews.length == 0) return;
          else if (scope.currentViewIndex == -1) scope.currentViewIndex = 0;
          else if (scope.currentViewIndex > 0) scope.currentViewIndex--;

          //Affectation de la vue à la Map
          var v = recordedViews[scope.currentViewIndex];
          setMapView(v);
          updatePrevNextBtns();
        };

        scope.nextViewHandler = function(e) {
          if (recordedViews.length == 0) return;
          else if (scope.currentViewIndex == -1) scope.currentViewIndex = 0;
          else if (scope.currentViewIndex < recordedViews.length - 1)
            scope.currentViewIndex++;

          //Affectation de la vue à la Map
          var v = recordedViews[scope.currentViewIndex];
          setMapView(v);
          updatePrevNextBtns();
        };

        var btnElt = $(element.children()[0]);
        btnElt.bind('click', function() {
          if (scope.isActive) {
            btnElt.removeClass('btn-info');
            btnElt.addClass('btn-default');
            scope.isActive = false;
          } else {
            btnElt.removeClass('btn-default');
            btnElt.addClass('btn-info');
            scope.isActive = true;
          }
        });

        scope.$on('closeToolsBar_toolbarmaphistoric', function() {
          if (scope.isActive) $('#toolbar_maphistoric_popover').click();
          btnElt.removeClass('btn-info');
          btnElt.addClass('btn-default');
          scope.isActive = false;
        });
      },
    };
  };

  toolbarmaphistoric.$inject = ['$timeout'];
  return toolbarmaphistoric;
});
