'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    gcPopup,
    extendedNgDialog,
    gaDomUtils,
    GeoTreatmentFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/treatments/treatIntersectLine.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        scope.activetreatment = '';
        scope.res = {};
        scope.inprogress = false;
        scope.interrupt = false;
        scope.geoLimit = GeoTreatmentFactory.DATABASE;

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        scope.stop = function() {
          GeoTreatmentFactory.stoptreatment(scope.state).then(function(data) {
            scope.inprogress = false;
            scope.interrupt = true;
            console.log(data);
          }).catch(handlePromiseError);
        };

        scope.run = function(fti1, fti2) {
          scope.inprogress = true;
          const featureCollections = [];
          const spatialClause = 
            GeoTreatmentFactory.getSpatialClause(
              scope.geoLimit,
              scope.map,
              scope.limitZoneGeometry,
              [fti1.name],
              featureCollections);
          let param = {
            spatialclause: spatialClause,
            featureCollections: featureCollections,
            fti1: fti1.uid,
            fti2: fti2.uid,
            srid: scope.map.getView().getProjection().getCode()
          };
          GeoTreatmentFactory.treatment(param, 'IntersectLine').then(function(data) {
            scope.state = data.data;
            scope.httpStatus=data.status;
            GeoTreatmentFactory.tick(scope, ['line1', 'line2']);
          }).catch(handlePromiseError);
        };
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'gcPopup',
    'extendedNgDialog',
    'gaDomUtils',
    'GeoTreatmentFactory',
  ];
  return basemapwidget;
});
