'use strict';
define([
  'angular',
  'ol3js',
  //'modules/map/controllers/mapcontroller',
  //'modules/map/directives/gcmap',
  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'toastr',

  'ng-table',
], function(angular, ol) {
  // generation du module
  var st = angular.module('gc_style_service', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
  ]);
  // ajout service

  // ajout controller
  // map.controller('MapController',mapController);
  // ajout directive
  //map.directive('gcmap',mgcmap);

  // ajout factory

  //ajout provider
  st.provider('gcStyleFactory', function() {
    var selectStroke = new ol.style.Stroke({
      color: [255, 128, 0, 0.75],
      width: 10,
    });

    var selectFill = new ol.style.Fill({
      color: [255, 255, 0, 0.75],
    });

    var selectStyle = new ol.style.Style({
      fill: selectFill,
      stroke: selectStroke,
      image: new ol.style.Circle({
        radius: 10,
        fill: selectFill,
        stroke: selectStroke,
      }),
    });

    var importStroke = new ol.style.Stroke({
      color: [0, 0, 0, 0.75],
      width: 1,
    });

    var importStyle = new ol.style.Style({
      //fill: importFill,
      stroke: importStroke,
      image: new ol.style.Circle({
        radius: 2,
        //fill: importFill,
        stroke: importStroke,
      }),
    });

    var hlStroke = new ol.style.Stroke({
      color: [240, 0, 0, 0.5],
      width: 6,
    });

    var hlFill = new ol.style.Fill({
      color: [255, 0, 0, 0.5],
    });

    const hlStyle = new ol.style.Style({
      fill: hlFill,
      stroke: hlStroke,
      image: new ol.style.Circle({
        radius: 10,
        fill: hlFill,
        stroke: hlStroke,
      }),
    });

    var srStyle = new ol.style.Style({
      stroke: new ol.style.Stroke({
        color: [0, 0, 0, 1],
        width: 1,
      }),
    });
    var editStyle = new ol.style.Style({
      fill: new ol.style.Fill({
        color: 'rgba(255, 255, 255, 0.2)',
      }),
      stroke: new ol.style.Stroke({
        color: '#ffcc33',
        width: 2,
      }),
      image: new ol.style.Circle({
        radius: 7,
        fill: new ol.style.Fill({
          color: '#ffcc33',
        }),
      }),
    });
    var geolocationStyle = new ol.style.Style({
      fill: new ol.style.Fill({
        color: [255, 0, 0, 0.1],
      }),
      stroke: new ol.style.Stroke({
        color: [255, 0, 0, 0.9],
        width: 3,
      }),
      image: new ol.style.Circle({
        radius: 5,
        fill: new ol.style.Fill({
          color: [255, 0, 0, 0.9],
        }),
        stroke: new ol.style.Stroke({
          color: [255, 0, 0, 1],
          width: 3,
        }),
      }),
    });


    const showVerticesStyleFc = () => {
      const regShape = new ol.style.Circle({
        points: 4,
        radius: 6,
        fill: new ol.style.Fill({ color: 'white' }),
        stroke: new ol.style.Stroke({ color: 'black', width: 2 }),
      });

      return [
        new ol.style.Style({
          image: regShape,
          geometry: (feature) => {
            let coordinates, geom;
            geom = feature.getGeometry();
            if (geom.getType() == 'Point') {
              coordinates = geom.getCoordinates();
            }
            else if (geom.getType() === 'LineString') {
              coordinates = geom.getCoordinates();
            }
            else {
              coordinates = geom.getCoordinates()[0];
            }
            return new ol.geom.MultiPoint(coordinates);
          },
        }),
        new ol.style.Style({
          stroke: selectStroke,
        }),
      ];
    };


    var measureStyle = new ol.style.Style({
      fill: new ol.style.Fill({
        color: 'rgba(255, 255, 255, 0.2)',
      }),
      stroke: new ol.style.Stroke({
        color: 'rgba(32,32,32, 0.5)',
        lineDash: [5, 5],
        width: 2,
      }),
      image: new ol.style.Circle({
        radius: 5,
        stroke: new ol.style.Stroke({
          color: 'rgba(255,165,0, 0.7)',
        }),
        fill: new ol.style.Fill({
          color: 'rgba(255, 255, 255, 0.2)',
        }),
      }),
    });

    var styles = {
      select: selectStyle,
      import: importStyle,
      highlight: hlStyle,
      selectrectangle: srStyle,
      edit: editStyle,
      geolocation: geolocationStyle,
      verticeShow: showVerticesStyleFc,
      measure: measureStyle,
    };

    this.$get = function() {
      return {
        getStyle: function(type) {
          return styles[type];
        },
        getStyleFunction: function(type) {
          return function(feature, resolution) {
            return styles[feature.get('styleId')];
          };
        },
      };
    };
  });

  return st;
});
