/**
 * Service used for CopyPasteAttribute
 */
'use strict';
define(function() {
  return function() {
    let CopyPasteAttributeFactory = {};
    let storedObjects = [];

    function getStoredObject(uid) {
      return storedObjects[uid];
    }

    function storeObject(value, fti) {
      fti.attributes.forEach( attribute => {
        if(attribute.type.startsWith('g2c.attachment')) {
          delete value[attribute.name];
        }
      });
      storedObjects[fti.uid] = value;
    }

    return {
      CopyPasteAttributeFactory: CopyPasteAttributeFactory,
      StoreObject: storeObject,
      GetStoredObject: getStoredObject,
    };
  };
});
