'use strict';
define(function() {
  var gcelement = function() {
    return {
      templateUrl: 'js/XG/widgets/mapapp/bizedition/views/selectOptions.html',
      restrict: 'E',
      scope: {
        isActive: '=',
        selectMode: '=',
        selectType: '=',
        interactionOn: '=',
        onselectoptionchange: '&',
        isactivepoint: '=',
        xconstraint:"=",
        yconstraint:"=",
        isxconstraint:'=',
        isyconstraint:'=',
        selectedsrid: '=',
        onSridSelected : '&',
        srids:"=",
        map: '=?' // pour désactiver les intéractions
      },
      link: function(scope) {

        // model du bouton radio de déplacement de la carte
        scope.stopInteraction = {
          value: false
        };

        /**
         * Au changement de valeur du bouton radio du déplacement sur la carte:<ul><li>
         *   Eteins l'intéraction</li><li>
         *   "Uncheck" les boutons radio de sélection</li></ul>
         */
        scope.shutdownInteraction = () => {
          if (scope.interactionOn !== undefined && scope.interactionOn.hasOwnProperty('value')
              && typeof scope.interactionOn.value === 'boolean') {
            scope.interactionOn.value = false;
            scope.selectMode.value = 'off';
            if (scope.map) {
              scope.map.getInteractions().forEach(interaction => {
                if (interaction instanceof ol.interaction.Draw || interaction instanceof ol.interaction.DragBox) {
                  interaction.setActive(false);
                }
              });
            }
          }
        };

        /**
         * Au clic sur un mode de sélection (rectangulaire, polygonal...):<ul><li>
         *   Re-active l'intéraction</li><li>
         *   "Uncheck" le bouton radio du déplacement sur la carte
         */
        scope.$watch('selectMode', () => {
          if (typeof scope.selectMode.value === 'string' && scope.selectMode.value !== 'off' &&
              scope.interactionOn !== undefined && scope.interactionOn.hasOwnProperty('value')
              && typeof scope.interactionOn.value === 'boolean') {
            scope.interactionOn.value = true;
            scope.stopInteraction.value = false;
          }
        }, true);
      },
    };
  };

  gcelement.$inject = [];
  return gcelement;
});
