'use strict';
define(function() {
  var gcelement = function (EditFactory, EditTypesFactory, $q, EditRulesFactory, gclayers,
      gcRestrictionProvider, CopyPasteAttributeFactory, bizeditProvider,
      FeatureTypeFactory, $timeout, FeatureAttachmentFactory, gaJsUtils, mapJsUtils, BizEditFactory, $filter) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/bizedition/views/bizeditsave.html',
      restrict: 'E',
      scope: false,
      link: function(scope) {
        var format = new ol.format.GeoJSON();
        var templatefeatcollect = {
          type: 'FeatureCollection',
          features: [],
        };
        /**
         * Rempli le tableau features des objets graphiques encodés en json,
         * destinés à la sauvegarde.
         * @returns {undefined}
         */
        function prepareFeatures() {
          /**
           * Récupére ou crée si il n'existe pas, l'objet associé à une couche
           * et contenant les features à ajouter, mettre à jour, supprimer.
           * adds et updates contienent une collection de Feature en Json.
           * deletes ne contient que les id. f_XX contient les ol.Features.
           *
           * @param {type}
           *            ftiUid
           * @returns
           */
          function getOrCreateRecordsObject(ftiUid, historicFtiUid) {
            if (allRecordsToDo[ftiUid] == undefined) {
              allRecordsToDo[ftiUid] = {
                adds: angular.copy(templatefeatcollect),
                updates: angular.copy(templatefeatcollect),
                deletes: [],
                toHistorize: angular.copy(templatefeatcollect),
                toDepose: angular.copy(templatefeatcollect),
                historicFtiUid: historicFtiUid,
                f_adds: [],
                f_updates: [],
                f_deletes: [],
                f_toHistorize: [],
                f_toDepose: [],
              };
            }
            return allRecordsToDo[ftiUid];
          }

          // Préparation des données pour la sauvegarde de la session
          // d'édition (scope.editdescription)
          var allRecordsToDo = {};

          // Traitement de l'objet principal //
          if (scope.editdescription.editedfeature.saved != true) {
            var recordsObject = getOrCreateRecordsObject(
              scope.editdescription.fti.uid,
              scope.editdescription.fti.historicFtiUid
            );

            var jsoneditedfeature = format.writeFeatureObject(
              scope.editdescription.editedfeature
            );
            if (jsoneditedfeature.properties == null) {
              jsoneditedfeature.properties = {};
            }
            jsoneditedfeature['id'] = jsoneditedfeature['id'] || scope.editdescription.editedfeature.id_;
            jsoneditedfeature['fti'] = scope.editdescription.fti.uid;
            delete jsoneditedfeature.properties.objectIsCopied;
            if (
              scope.editdescription.editType ===
              EditTypesFactory.editTypes.add.name
            ) {
              recordsObject.adds.features.push(jsoneditedfeature);
              recordsObject.f_adds.push(scope.editdescription.editedfeature);
            } else if (scope.editdescription.editType === EditTypesFactory.editTypes.update.name
                || scope.editdescription.editType === EditTypesFactory.editTypes.updateattributes.name
                || scope.editdescription.editType === EditTypesFactory.editTypes.reverse.name) {
              recordsObject.updates.features.push(jsoneditedfeature);
              recordsObject.f_updates.push(scope.editdescription.editedfeature);
            }
            // Pour la suppression
            else if (
              scope.editdescription.editType ===
              EditTypesFactory.editTypes.delete.name
            ) {
              recordsObject.deletes.push(jsoneditedfeature.id);
              recordsObject.f_deletes.push(scope.editdescription.editedfeature);
            }

            // Historisation eventuelle
            else if (
              scope.editdescription.editType ===
              EditTypesFactory.editTypes.tohistorize.name
            ) {
              recordsObject.toHistorize.features.push(jsoneditedfeature);
              recordsObject.f_toHistorize.push(
                scope.editdescription.editedfeature
              );
            } else if (
              scope.editdescription.editType ===
              EditTypesFactory.editTypes.todepose.name
            ) {
              recordsObject.toDepose.features.push(jsoneditedfeature);
              recordsObject.f_toDepose.push(
                scope.editdescription.editedfeature
              );
            }
          }
          // Traitement des objets secondaires //
          for (
            var i = 0;
            i < scope.editdescription.relatedfeatures.length;
            i++
          ) {
            var related = scope.editdescription.relatedfeatures[i];
            var feature = related.feature;
            // On ne sauve pas le feature si celui-ci est marqué comme étant
            // dejà sauvegardé.
            if (feature.saved === true) continue;

            var ftuid = related.fti.uid;
            jsoneditedfeature = format.writeFeatureObject(feature);
            jsoneditedfeature['fti'] = ftuid;
            if (jsoneditedfeature.properties == null) {
              jsoneditedfeature.properties = {};
            }
            let recordsObject = getOrCreateRecordsObject(
              ftuid,
              related.historicFtiUid
            );

            delete jsoneditedfeature.properties.objectIsCopied;
            if (related.editType === EditTypesFactory.editTypes.add.name) {
              recordsObject.adds.features.push(jsoneditedfeature);
              recordsObject.f_adds.push(feature);
            } else if (
              related.editType === EditTypesFactory.editTypes.update.name ||
              related.editType === EditTypesFactory.editTypes.updateattributes.name ||
              related.editType === EditTypesFactory.editTypes.reverse.name
            ) {
              recordsObject.updates.features.push(jsoneditedfeature);
              recordsObject.f_updates.push(feature);
            }
            // Pour la suppression, voir comment récupérer l'identifiant du
            // feature
            else if (
              related.editType === EditTypesFactory.editTypes.delete.name
            ) {
              recordsObject.deletes.push(jsoneditedfeature.id);
              recordsObject.f_deletes.push(feature);
            }
            // Historisation eventuelle
            else if (
              related.editType === EditTypesFactory.editTypes.tohistorize.name
            ) {
              recordsObject.toHistorize.features.push(jsoneditedfeature);
              recordsObject.f_toHistorize.push(feature);
            } else if (
              related.editType === EditTypesFactory.editTypes.todepose.name
            ) {
              recordsObject.toDepose.features.push(jsoneditedfeature);
              recordsObject.f_toDepose.push(feature);
            }
          }

          return allRecordsToDo;
        }

        /**
         * [save description]
         *
         * @return {Promise} [description]
         */
        function performSaving() {
          var defer = $q.defer();
          var srid = scope.map.getView().getProjection().getCode();
          var promises = [];

          scope.allRecords = prepareFeatures();

          const areMissingAttributes = Object.keys(scope.allRecords || {}).reduce((missingAttributes, featureUid) => {
            const fti = FeatureTypeFactory.resources.featuretypes
              .find(featuryType => featuryType.uid === featureUid) || { attributes: [] };
            scope.allRecords[featureUid].adds.features.forEach((feature) => {
              const missingMandatoryAttributes = bizeditProvider.getMissingMandatoryAttributes(
                fti.attributes, 1, undefined, feature.properties
              );
              if (missingMandatoryAttributes.length) {
                missingAttributes = true;
              }
            });
            return missingAttributes;
          }, false);

          if (areMissingAttributes) {
            require('toastr').error('Des attributs obligatoires sont à renseigner dans les objets dépendants');
            scope.updatesToSave = true;
            defer.reject();
            return defer.promise;
          }

          if (scope.selectfti.type === 'esri') {
            promises.push(EditRulesFactory.applyEdits(scope));
          } else {
            // -- Tableau de promesses permettant de savoir
            // -- quand toutes les sauvegardes seront terminées.

            // -- Pour chaque couche, enregistrement des features ajoutés,
            // -- mis à jour et supprimés
            angular.forEach(scope.allRecords, function (value, key) {
              // key => ftiUid
              // value => recordsObject
              var recordsObject = value;
              var ftiUid = key;

              if (
                recordsObject.adds != undefined &&
                recordsObject.adds.features.length > 0
              ) {
                var callBackSuccess = getCallbackSuccess(
                  recordsObject,
                  ftiUid,
                  'adds'
                );
                var callBackError = getCallbackError(
                  recordsObject,
                  ftiUid,
                  'adds'
                );

                var promise2 = EditFactory.add(
                  ftiUid,
                  recordsObject.adds,
                  srid
                ).then(callBackSuccess, callBackError);

                // promise2 sera resolue lorsque un des callBalck aura fini son
                // traitement de la réponse.
                promises.push(promise2);
              }
              if (
                recordsObject.updates != undefined &&
                recordsObject.updates.features.length > 0
              ) {
                let callBackSuccess = getCallbackSuccess(
                  recordsObject,
                  ftiUid,
                  'updates'
                );
                let callBackError = getCallbackError(
                  recordsObject,
                  ftiUid,
                  'updates'
                );

                let promise2 = EditFactory.update(
                  ftiUid,
                  recordsObject.updates,
                  srid
                ).then(callBackSuccess, callBackError);

                promises.push(promise2);
              }
              if (
                recordsObject.deletes != undefined &&
                recordsObject.deletes.length > 0
              ) {
                let callBackSuccess = getCallbackSuccess(
                  recordsObject,
                  ftiUid,
                  'deletes'
                );
                let callBackError = getCallbackError(
                  recordsObject,
                  ftiUid,
                  'deletes'
                );

                let promise2 = EditFactory.remove(
                  ftiUid,
                  recordsObject.deletes
                ).then(callBackSuccess, callBackError);

                promises.push(promise2);
              }
              if (recordsObject &&
                recordsObject.toHistorize &&
                recordsObject.toHistorize.features &&
                recordsObject.toHistorize.features.length > 0
              ) {
                let callBackSuccess = getCallbackSuccess(
                  recordsObject,
                  ftiUid,
                  'toHistorize'
                );
                let callBackError = getCallbackError(
                  recordsObject,
                  ftiUid,
                  'toHistorize'
                );
                let promise2 = EditFactory.historicize(
                  ftiUid,
                  recordsObject.toHistorize,
                  srid
                ).then(callBackSuccess, callBackError);

                promises.push(promise2);
              }
              if (
                recordsObject &&
                recordsObject.toDepose &&
                recordsObject.toDepose.features &&
                recordsObject.toDepose.features.length > 0
              ) {
                // KIS-3370: vérifie la bonne cohérence des champs avant dépose
                BizEditFactory.checkDeposeConsistency(ftiUid).then(
                    res => {
                      if (Array.isArray(res.data) && res.data.length > 0) {

                        // Affiche les erreurs de cohérence
                        const ftiName = FeatureTypeFactory.getFeatureTypeNameByUid(ftiUid);
                        const title = $filter('translate')('bizedition.deposeErrorTitle').replace('$1', ftiName);
                        swal({
                          title: title,
                          text: res.data.map(err => err.details.length > 0 ? err.details[0] : err.message).join('\n'),
                          type: 'error',
                          confirmButtonColor: '#428bca',
                          showCancelButton: false,
                          confirmButtonText: $filter('translate')('common.ok'),
                          showConfirmButton: true
                        });

                        // Précise les éventuelles erreurs de longueur de champ en console
                        const errortext = $filter('translate')('bizedition.fieldLengthError');
                        const errorDetails = res.data.filter(err => err.details.length > 0).map(err => err.details[0]);
                        console.error([errortext, ...errorDetails].join('\n'));

                        defer.resolve();
                        return defer.promise;
                      } else {
                        let callBackSuccess = getCallbackSuccess(
                            recordsObject,
                            ftiUid,
                            'toDepose'
                        );
                        let callBackError = getCallbackError(
                            recordsObject,
                            ftiUid,
                            'toDepose'
                        );
                        let promise2 = EditFactory.depose(
                            ftiUid,
                            recordsObject.toDepose,
                            srid,
                            'depose'
                        ).then(callBackSuccess, callBackError);

                        promises.push(promise2);
                      }
                    },
                    (err) => {
                      require('toastr').error(err.data);
                      defer.reject();
                      return defer.promise;
                    }
                );
              }
            });
          }

          function getCallbackSuccess(recordsObject, ftiUid, recordsType) {
            return function(result) {
              var data = result.data;

              // Si la reponse n'est pas un objet du service d'édition, il y a
              // une erreur
              if (data.create == undefined) {
                var msg =
                  'Erreur serveur: ' +
                  data.message +
                  ', details:' +
                  data.details[0];
                require('toastr').error(msg);
                console.error(msg);
                return;
              }

              if (recordsType === 'adds') {
                if (data.create.length === recordsObject.adds.features.length) {
                  // Marquage de chaque ol.Feature comme enregistré avec
                  // succès.
                  setSaveValidatedMarker(recordsObject.f_adds);
                  // Récupération des features sauvées avec un id affecté,
                  // encodés en json.
                  // Si les features ne contienent pas les id, c dernier se
                  // trouve quand meme dans data.create[i]
                  for (let i = 0; i < data.create.length; i++) {
                    let jsonFeature;
                    try {
                      jsonFeature = JSON.parse(data.create[i].json);
                      recordsObject.adds.features[i].id = jsonFeature.id;

                      // KIS-3298: on doit créer les fieldData des objets enregistrés sans ouvrir la popup d'édition attributaire
                      // rappel: les fieldData stockent le nom du sous-dossier UPLOAD dans lequel on été chargé les attachments
                      const fti = bizeditProvider.getFtiFromJsonFeature(jsonFeature, data.create, 0);
                      if (fti && !scope.fieldDatas.hasOwnProperty(fti.uid)) {

                        // rang de l'objet parmi tous les objets nouvellement créés du composant (-1 si objet principal)
                        const indexFeature = scope.editdescription.relatedfeatures.findIndex(relFeat => relFeat.id === jsonFeature.id);
                        scope.createAttributePopupFieldDatas(fti, indexFeature, null);
                      }

                    } catch (e) {
                      console.error(
                          'Error de parsing de result.data.create:' +
                          data.create[i],
                          e
                      );
                    }
                  }
                  // On copie tous les fichiers d'un objet avant de passer à l'objet suivant
                  bizeditProvider.copyFilesFromUploadToAttachmentFolder(data.create, 0, scope.fieldDatas);

                  // KIS-3135:  l’enregistrement des objets associés se fait après enregistrement de l’objet édité
                  // et une fois que son identifiant est récupéré (enregistrement en postSave si présence de règle postSave)
                  const hasPostSaveRule = scope.editdescription.fti.rules.some(rule => rule.type === 'PostSave');
                  if (data.create.length === 1 && !hasPostSaveRule) {
                    EditRulesFactory.bizEditSaveAssociatedFeatures(data.create, scope.editdescription);
                  }
                }
              } else if (recordsType === 'updates') {
                if (data.update.length === recordsObject.updates.features.length) {
                  setSaveValidatedMarker(recordsObject.f_updates);
                }
              } else if (recordsType === 'deletes') {
                if (data.delete.length === recordsObject.deletes.length) {
                  setSaveValidatedMarker(recordsObject.f_deletes);
                }
              } else if (recordsType === 'toHistorize') {
                if (data.hasOwnProperty('historic') && Array.isArray(data.historic)
                    && data.historic.length === recordsObject.toHistorize.features.length) {
                  setSaveValidatedMarker(recordsObject.f_toHistorize);
                }
              } else if (recordsType === 'toDepose') {
                // Comparer les id des features pour vérifier plus précisement
                // lesquels ont bien été sauvés.
                if (data.depose.length === recordsObject.toDepose.features.length) {
                  copyDeposeFeatureAttachment(data.depose, recordsObject.toDepose.features);
                  setSaveValidatedMarker(recordsObject.f_toDepose);
                }
              }
              gclayers.refreshlayerByid(ftiUid, scope.map);
              if (data.errors.length > 0) {
                console.error(
                  'Sauvegarde de type ' +
                    recordsType +
                    ' pour la couche uid:' +
                    ftiUid +
                    ' non effectuée !\n Cause:' +
                    data.errors[0]
                );
              }
              // enlève les fonctions spécifiques du menu contextuel. Préserve zoom +/-
              scope.resetContextMenu();
            };
          }

          function setSaveValidatedMarker(features) {
            for (var i = 0; i < features.length; i++) {
              features[i].saved = true;
            }
          }

          function getCallbackError(recordsObject, ftiUid, recordsType) {
            return function(result) {
              if (scope.editdescription.editType === EditTypesFactory.editType.reverse.name) {
                cancelReversedGeometries();
              }
              gcRestrictionProvider.showDetailsErrorMessage(result);
              console.error(
                'Erreur de sauvegarde de type ' +
                  recordsType +
                  ' pour la couche uid:' +
                  ftiUid +
                  ' ,response:' +
                  result
              );
            };
          }

          // Renvoi une promesse qui sera résolue lorsque toutes les promesses
          // du tableau seront résolues;
          return $q.all(promises);
        } // end performSaving


        /**
         * Reconstruire la couche openLayers
         * contenant les objets d'accroche (SNAP).
         */
        scope.initializeSnapLayer = (descriptionObject) => {
          $timeout(() => {
            scope.reset();
            scope.saveinProgress = false;
            // l'exécution de cette méthode depuis bizeditwidget rend editdescription undefined
            // dans le cas de l'edition metier (maj) celle là casse le snap
            // const editdescription = scope.editdescription ? scope.editdescription : descriptionObject;
            // EditRulesFactory.executeInitRules(editdescription,
            //   scope.selectfti,scope.map);
          });
        };


        const performPostSaving = () => {
          scope.saveinProgress = false;
          //Une fois les sauvegardes terminées, lancement des règles post-sauvegarde.
          const promise = EditRulesFactory.executePostSavingRules(
            scope.editdescription,
            scope.map,
            scope.allRecords
          );

          promise.then((res) => {
            const promises = [];
            if(Array.isArray(scope.editdescription.relatedfeatures) && scope.editdescription.relatedfeatures.length>0){
              let i=0;
              for (let relatedFeat of scope.editdescription.relatedfeatures) {
                const promise = EditRulesFactory.executePostSavingRules(
                  relatedFeat,
                  scope.map,
                  scope.allRecords,
                  i++
                ).then(() => {
                  relatedFeat.editType = 'update';
                  relatedFeat.editedfeature.saved = false;
                  relatedFeat.feature = relatedFeat.editedfeature;
                })
                promises.push(promise);
              }
            }
            $q.all(promises).then(()=>{
              //set object from response to populate the pop-up
              const rules = scope.editdescription.fti.rules;
              rules.find( (attribute) => {
                if (attribute.name === 'CopyPasteAttribute') {
                  const currentObject = res;
                  currentObject['objectIsCopied'] = true;
                  CopyPasteAttributeFactory.StoreObject(
                    currentObject,
                    scope.editdescription.fti
                  );
                }
              });

              ///// add editdescription.editedfeature.saved as true in case of saving
              if (scope.editdescription.editType === 'add' ||
                  scope.editdescription.editType === 'update' ||
                  scope.editdescription.editType === 'updateattributes') {
                scope.editdescription.editedfeature.saved = true;
                scope.editdescription.editedfeature.attrEdited = true;
              }

              if (scope.editdescription.performUpdateOnPostsaving === true) {
                scope.editdescription.editType = 'update';
                scope.editdescription.editedfeature.saved = false;
                performSaving();
              }
              //(reprendre les feature add et update et effectuer des updates)
              //Règles post-sauvegarde terminées.
              scope.endsave(scope.allRecords);
            })
          },
          () => {
            scope.endsave(scope.allRecords);
          }
          );
        };


        const performSaveAndPostSaving = () => {
          performSaving().then(
            (res) => {
              //-- Dans le cas esr, l'applyedits qui est appelé
              //-- s'occupe aussi du postSaving.
              if (!res || ! res[0] || res[0].type !== 'esri') {
                performPostSaving();
              }
              else {
                scope.initializeSnapLayer();
              }
            },
            (error) => {
              console.error('performSaveAndPostSaving : ', error);
              scope.saveinProgress = false;
            }
          );
        };


        scope.save = () => {
          scope.saveinProgress = true;

          if (scope.editdescription.editedfeature != undefined) {
            if (scope.editdescription.geometryStatus === 'toReverse') {
              reverseLine();
              performSaveAndPostSaving();
            } else if (
              scope.editdescription.geometryStatus !== 'modifiedAndNotSaved'
            ) {
              //-- Dans le cas de modification d'objet:
              //-- -- Les EndRules ont été exécutées par activation
              //-- -- de la "coche", il ne reste donc plus qu'à exécuter
              //-- -- les règles PostSaving.
              //-- Dans le cas de création d'objet:
              //-- -- geometryStatus contient "undefined", et les end rules
              //-- -- sont exécutées dans les traitements par défaut,
              //-- -- donc à ne pas exécuter à nouveau.
              performSaveAndPostSaving();
            } else {
              //Execution des règles 'onend'.
              var saveEnd = EditRulesFactory.executeEndRules(
                scope.editdescription,
                scope.editdescription.fti,
                scope.map
              );
              saveEnd.then(
                () => {
                  console.info('EditRulesFactory.executeEndRules done.');
                  console.log('scope.editdescription', scope.editdescription);
                  performSaveAndPostSaving();
                },
                (errorReason) => {
                  if (errorReason && typeof errorReason === 'string') {
                    console.error(
                        'EditRulesFactory.executeEndRules, error:' + errorReason
                    );
                  }
                  $timeout(() => {
                    scope.reset();
                    scope.saveinProgress = false;
                  });
                }
              );
            }
          }
        };

        /**
         * Copie les fichiers attachés d'un objet déposé depuis le dossier d'attachment de cet objet vers le dossier d'attachment de l'objet de dépose.<br>
         * Ex. copie les fichiers attachés depuis le dossier "ATTACHMENTS/Regards/Regards.720" vers le dossier "ATTACHMENTS/Regards_depose/Regards_depose.24"<br>
         * Cette méthode suppose que les tableaux fournis en paramètres soient classés dans le même ordre: deposedFeatures[i] est l'objet déposé de toDeposeFeatures[i].
         * @param {object[]} deposedFeatures tableau d'objets de dépose après création et enregistrement.
         * Chaque objet présente l'id de l'objet ainsi qu'une propriété json constituant l'objet en string json
         * @param {object[]} toDeposeFeatures tableau d'objets à déposer. Chaque objet présente l'id de l'objet ainsi que les propriétés non nulles
         */
        const copyDeposeFeatureAttachment = (deposedFeatures, toDeposeFeatures) => {
          if (Array.isArray(deposedFeatures) && Array.isArray(toDeposeFeatures)) {
            const deposedLength = deposedFeatures.length;
            const toDeposedLength = toDeposeFeatures.length;
            if (deposedLength > 0 && deposedLength === toDeposedLength) {
              scope.saveinProgress = true;
              const promises = [];
              for (let i = 0; i < deposedLength; i++) {
                const source = bizeditProvider.buildRequestParameter(toDeposeFeatures[i]);
                const destination = bizeditProvider.buildRequestParameter(deposedFeatures[i]);
                promises.push(FeatureAttachmentFactory.copyFilesToFeature(source, destination, [], true));
              }
              $q.all(promises).finally(
                () => {
                  scope.saveinProgress = false;
                }
              );
            }
          }
        };

        /**
         * Inverse le sens de digitalisation d’une ligne ou d'une sélection de lignes
         * au clic sur le bouton "Inverser le sens" (flèches inversées)
         */
        const reverseLine = () => {

          // inverse le sens de l'objet principal
          const editedGeometry = scope.editdescription.editedfeature.getGeometry();
          const backupGeometry = editedGeometry.clone();
          const reversedGeometry = mapJsUtils.getReversedLinearGeometry(editedGeometry);
          scope.editdescription.editedfeature.setGeometry(reversedGeometry);

          // inverse le sens des objets liés linéaires
          const relatedFeaturesBackupGeometries = reverseRelatedFeaturesGeometries(scope.editdescription);

          // objet de sauvegarde pour restaurer en cas d'échec (cf. getCallbackError)
          scope.reversingLineData = {
            bypassRules: ['MoveExtremityPoint', 'MoveObjectsOnLine'],
            backupGeometry: backupGeometry,
            relFeatsBackupGeoms: relatedFeaturesBackupGeometries
          };
        };

        /**
         * Inverse le sens de la géométrie de chaque objet relié de la session d'édition ("relatedfeatures").
         * Dans la structure actuelle d'une session d'édition, quand l'utilisateur sélectionne plusieurs objets,
         * le premier objet sélectionné est l'objet principal (editdescription.editedfeature)
         * et les autres objets sélectionnés sont des objets reliés (editdescription.relatedfeatures).
         * @param editDescription objet stockant les caractéristiques d'une session d'édition
         * @return {Map<any, ol.geom.LineString|ol.geom.MultiLineString>} map contenant pour chaque objet relié: l'id ol de chaque objet relié et sa géométrie avant inversion de sens
         */
        const reverseRelatedFeaturesGeometries = (editDescription) => {

          // traite le cas où la session d'édition est nulle ou incorrecte
          if (!gaJsUtils.notNullAndDefined(editDescription) || !Array.isArray(editDescription.relatedfeatures)) {
            console.error(`reverseRelatedFeaturesGeometries - La session d'édition est nulle ou ne possède aucun objet lié : editdescription = `, editDescription);
            return new Map();
          }

          // conteneur des géométries d'origine
          const backupGeometries = new Map();

          const lineTypes = ['MultiLineString', 'LineString'];

          // traite chaque objet lié
          for (const relatedFeature of editDescription.relatedfeatures) {

            if (!gaJsUtils.notNullAndDefined(relatedFeature.feature)) {
              console.error(`reverseRelatedFeaturesGeometries - L'objet lié ${relatedFeature.id} ne possède pas de feature openlayers. relatedFeature = `, relatedFeature);
              return backupGeometries;
            }
            const olRelatedFeature = relatedFeature.feature;
            const relatedGeometry = olRelatedFeature.getGeometry();

            // vérifie que l'objet soit bien un linéaire
            if (relatedGeometry !== null && lineTypes.includes(relatedGeometry.getType())) {

              // copie la géométrie d'origine
              const relatedOriginalGeometry = relatedGeometry.clone();

              // recherche l'id de l'objet openlayers pour insertion dans le conteneur
              let featId;
              if (gaJsUtils.notNullAndDefined(olRelatedFeature.getId())) {
                featId = olRelatedFeature.getId();
              } else {
                // dans le cas impossible où une feature existante n'aurait pas d'id,
                // alors on identifie la feature à l'aide d'une propriété custom "id"
                featId = gaJsUtils.guid();
                olRelatedFeature.set('id', featId);
              }
              backupGeometries.set(featId, relatedOriginalGeometry);

              // inverse le sens de la géométrie de l'objet openlayers
              const relatedReversedGeometry = mapJsUtils.getReversedLinearGeometry(relatedGeometry);
              olRelatedFeature.setGeometry(relatedReversedGeometry);
            }
          }

          // retourne le conteneur des géométrie initiales pour permettre une restauration si une erreur serveur intervient
          return backupGeometries;
        };

        /**
         * Lorsque une erreur serveur est levée, alors l'inversion de sens est annulée.
         * Cette méthode permet de restaurer la géométrie des objets liés dans le sens d'origine
         * @param backupGeometries map contenant la géométrie initiale des objets reliés de la session d'édition
         * @param editDescription objet contenant les informations de la session d'édition
         */
        const restoreRelatedFeaturesGeometries = (backupGeometries, editDescription) => {
          if (backupGeometries && backupGeometries.size > 0 && Array.isArray(editDescription.relatedfeatures)) {
            for (const relatedFeature of editDescription.relatedfeatures) {
              const olRelatedFeature = relatedFeature.feature;
              let featId;
              if (gaJsUtils.notNullAndDefined(olRelatedFeature.getId())) {
                featId = olRelatedFeature.getId();
              } else if (gaJsUtils.notNullAndDefined(olRelatedFeature.get('id'))) {

                // Dans le cas impossible où une feature existante n'aurait pas d'id,
                // on peut toujours identifier la feature à l'aide d'une propriété custom "id" définie lors de l'inversion de sens
                featId = String(olRelatedFeature.get('id')).slice();

                // supprime la propriété custom "id" pour ne pas générer de conflits
                olRelatedFeature.unset('id');
              }
              if (gaJsUtils.notNullAndDefined(featId) && backupGeometries.has(featId)) {
                olRelatedFeature.setGeometry(backupGeometries.get(featId));
              }
            }
          }
        };

        /**
         * Dans le cas d'une inversion de sens d'objets linéaires et
         * dans le cas d'échec de la mise à jour des objets dans le serveur,
         * restaure la géométrie de l'objet principal et exécute la restauration des objets liés
         */
        const cancelReversedGeometries = () => {
          if (scope.reversingLineData) {
            require('toastr').error($filter('translate')('rulecfg.reverseLineFailed'));
            // restaure le sens d'origine de la géométrie
            scope.editdescription.editedfeature.setGeometry(scope.reversingLineData.backupGeometry);
            // restaure le sens d'origine de la géométrie de chaque objet relié
            restoreRelatedFeaturesGeometries(scope.reversingLineData.relFeatsBackupGeoms, scope.editdescription);
          }


        };
      },
    };
  };
  gcelement.$inject = ['EditFactory', 'EditTypesFactory', '$q', 'EditRulesFactory', 'gclayers',
    'gcRestrictionProvider', 'CopyPasteAttributeFactory', 'bizeditProvider', 'FeatureTypeFactory',
    '$timeout', 'FeatureAttachmentFactory', 'gaJsUtils', 'mapJsUtils', 'BizEditFactory', '$filter'];
  return gcelement;
});
