'use strict';
define(function() {
  var HpoUserAppFactory = function(
    $http,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    $location,
    HpoCarteAppFactory
  ) {
    function getUser() {
      return HpoCarteAppFactory.getInitProvider().getUser();
    }

    function getUserRoles() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      return user.roles;
    }

    function isKisRootUser() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return user.name === 'root';
    }

    function isRootUser() {
      var user = HpoCarteAppFactory.getInitProvider().getUser();
      var roles = user.roles;
      var rolesNames = roles.map(function(x) {
        return x.name;
      });
      return rolesNames.indexOf('rootUser') !== -1;
    }

    function isRoleExist(roleName) {
      let user = HpoCarteAppFactory.getInitProvider().getUser();
      return user.roles.findIndex(role => role.name ===roleName) !==-1
    }

    function getNavigationHpo() {
      var navigations = [];

      var title = {
        main_title: 'hpo.home.title',
        label: 'hpo.home.title',
        icon: 'home',
        template: 'js/XG/widgets/hpoapp/main/views/templates/hpo.home.tpl.html',
        visible: true,
        description: '',
      };

      var admin = {
        main_title: 'hpo.admin.title',
        label: 'hpo.admin.title',
        icon: 'cogs',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/hpo.admin.tpl.html',
        visible: true,
        description: '',
      };

      var dataCheck = {
        label: 'hpo.data.check.title',
        icon: 'table',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.check.tpl.html',
        visible: true,
        description: '',
      };
      // var dataExchange = {
      //   label: 'hpo.data.exchange.title',
      //   icon: 'exchange',
      //   template:
      //     'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.exchange.tpl.html',
      //   visible: true,
      //   description: '',
      // };
      var dataPrepare = {
        label: 'hpo.data.prepare.title',
        icon: 'pencil',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.tpl.html',
        visible: true,
        description: '',
      };
      var standardisationData = {
        label: 'hpo.data.standardisation.title',
        icon: 'magic',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.standardisation.tpl.html',
        visible: true,
        description: '',
      };
      var dataValidation = {
        label: 'hpo.data.validation.title',
        icon: 'exchange',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.validation.tpl.html',
        visible: false,
        description: '',
      };
      var checkvalidation = {
        label: 'hpo.data.checkvalidation.title',
        icon: 'check',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.checkvalidation.tpl.html',
        visible: true,
        description: '',
      };
      var data = {
        main_title: 'hpo.data.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'database',
        subs: [],
      };

      var jeuChoice = {
        label: 'hpo.model.jeu.title',
        icon: 'list',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.jeu.tpl.html',
        visible: true,
        description: '',
      };
      var modelChoice = {
        label: 'hpo.model.choice.title',
        icon: 'table',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.choice.tpl.html',
        visible: true,
        description: '',
      };
      var modelCalage = {
        label: 'hpo.model.calage.title',
        icon: 'edit',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.calage.tpl.html',
        visible: true,
        description: '',
      };
      var modelValidation = {
        label: 'hpo.model.validation.title',
        icon: 'check',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.validation.tpl.html',
        visible: true,
        description: '',
      };
      var modelPrevision = {
        label: 'hpo.model.prevision.title',
        icon: 'area-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/model/hpo.model.prevision.tpl.html',
        visible: true,
        description: '',
      };
      var model = {
        main_title: 'hpo.model.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'line-chart',
        subs: [],
      };

      const optimalRenewalRate = {
        label: 'hpo.strategic.optimalRenewalRate.title',
        icon: 'line-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/strategic/hpo.strategic.optiRenRate.tpl.html',
        visible: true,
        description: '',
      };
      const strategic = {
        main_title: 'hpo.strategic.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'sliders',
        subs: [optimalRenewalRate],
      };


      const renewalOpportunity = {
        label: 'hpo.tactical.renewalOpportunity.title',
        icon: 'road',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/tactical/hpo.tactical.renewalOpportunity.tpl.html',
        visible: true,
        description: '',
      };
      const tactical = {
        main_title: 'hpo.tactical.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'bar-chart',
        subs: [renewalOpportunity],
      };

      var leakSeach = {
        main_title: 'hpo.searchLeak.rechercheFuite',
        label: 'hpo.searchLeak.rechercheFuite',
        icon: 'search',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/hpo.leakSeach.tpl.html',
        visible: true,
        description: '',
      };
      var leakSeachParent = {
        main_title: 'hpo.searchLeak.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'search',
        subs: [leakSeach],
      };
      var multicritereComposantFilter = {
        label: 'hpo.multicritere.filter.title',
        icon: 'filter',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.filter.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereAutomatisation = {
        label: 'hpo.multicritere.automatisation.title',
        icon: 'laptop',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.automatisation.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereParameters = {
        label: 'hpo.multicritere.parameters.title',
        icon: 'cog',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.parameters.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereConstruct = {
        label: 'hpo.multicritere.construct.title',
        icon: 'plus',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.construct.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereAnalyse = {
        label: 'hpo.multicritere.analyse.title',
        icon: 'edit',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.analyse.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereIndicateur = {
        label: 'hpo.multicritere.indicateur.title',
        icon: 'plus-square',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.indicateur.tpl.html',
        visible: true,
        description: '',
      };
      var multicritereCompare = {
        label: 'hpo.multicritere.compare.title',
        icon: 'line-chart',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.compare.tpl.html',
        visible: true,
        description: '',
      };

      var multicritereCorrespondance = {
        label: 'hpo.multicritere.correspondance.title',
        icon: 'arrows-h',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.correspondance.tpl.html',
        visible: true,
        description: '',
      };

      var multicritereRetenu = {
        label: 'hpo.multicritere.retenu.title',
        icon: 'mouse-pointer',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/multicritere/hpo.multicritere.retenu.tpl.html',
        visible: true,
        description: '',
      };

      var multicritere = {
        main_title: 'hpo.multicritere.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'code-fork',
        subs: [],
      };

      var chantiersCreate = {
        label: 'hpo.chantiers.creation.title',
        icon: 'plus',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/chantiers/chantiers.tpl.html',
        visible: true,
        description: '',
      };
      var chantiersListe = {
        label: 'hpo.chantiers.liste.title',
        icon: 'list',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/chantiers/liste.chantiers.tpl.html',
        visible: true,
        description: '',
      };
      var chantiers = {
        main_title: 'hpo.chantiers.title',
        isCollapsed: true,
        activeSub: false,
        icon: 'cubes',
        subs: [],
      };

      var chantiersAutomatique = {
         label: 'hpo.chantiersautomatique.title',
        icon: 'wrench',
        template:
          'js/XG/widgets/hpoapp/main/views/templates/chantiersautomatique/hpo.chantiersautomatique.tpl.html',
        visible: true,
        description: '',
      };

      if (isKisRootUser()) {
        data.subs = data.subs.concat([
          dataCheck,
          //dataExchange,
          dataPrepare,
          dataValidation,
          checkvalidation,
        ]);
        model.subs = model.subs.concat([
          jeuChoice,
          standardisationData,
          modelChoice,
          modelCalage,
          modelValidation,
          modelPrevision,
        ]);
        multicritere.subs = multicritere.subs.concat([
          multicritereComposantFilter,
          multicritereAutomatisation,
          multicritereParameters,
          multicritereConstruct,
          multicritereIndicateur,
          multicritereAnalyse,
          multicritereCompare,
          multicritereRetenu,
        ]);
        chantiers.subs = chantiers.subs.concat([
          chantiersAutomatique,
          multicritereCorrespondance,
          chantiersCreate,
          chantiersListe
        ]);
        navigations = navigations.concat([
          title,
          admin,
          data,
          model,
          strategic,
          tactical,
          leakSeachParent,
          multicritere,
          chantiers
        ]);
        return navigations;
      } else if (isRootUser()) {
        data.subs = data.subs.concat([
          dataCheck,
          //dataExchange,
          dataPrepare,
          dataValidation,
          checkvalidation,
        ]);
        model.subs = model.subs.concat([
          jeuChoice,
          standardisationData,
          modelChoice,
          modelCalage,
          modelValidation,
          modelPrevision,
        ]);
        multicritere.subs = multicritere.subs.concat([
          multicritereComposantFilter,
          multicritereAutomatisation,
          multicritereParameters,
          multicritereConstruct,
          multicritereIndicateur,
          multicritereAnalyse,
          multicritereCompare,
          multicritereRetenu,
        ]);
        chantiers.subs = chantiers.subs.concat([
          chantiersAutomatique,
          multicritereCorrespondance,
          chantiersCreate,
          chantiersListe,
        ]);
        navigations = navigations.concat([
          title,
          admin,
          data,
          model,
          leakSeachParent,
          strategic,
          tactical,
          multicritere,
          chantiers,
        ]);
        return navigations;
      }else{
        if(isRoleExist("HpoRole1_D")){
          data.subs = data.subs.concat([
            dataCheck,
            dataPrepare,
            dataValidation,
            checkvalidation,
          ]);
        }
        if(isRoleExist("HpoRole1_D") || isRoleExist("HpoRole2_DR") || isRoleExist("HpoRole8_CAR")){
          model.subs = model.subs.concat([
            jeuChoice,
            standardisationData
          ]);
        }
        if(isRoleExist("HpoRole3_M")){
          model.subs.push(modelChoice);
          model.subs.push(modelCalage);
        }
        if(isRoleExist("HpoRole3_M")|| isRoleExist("HpoRole4_MR") || isRoleExist("HpoRole8_CAR")){
          model.subs.push(modelValidation);
          model.subs.push(modelPrevision);
        }
        if(isRoleExist("HpoRole5_AMC")){
          multicritere.subs = multicritere.subs.concat([
            multicritereComposantFilter,
            multicritereAutomatisation,
            multicritereParameters,
            multicritereConstruct,
            multicritereIndicateur
          ]);
        }
        if(isRoleExist("HpoRole5_AMC") || isRoleExist("HpoRole6_AMCR")){
          multicritere.subs.push(multicritereAnalyse);
          multicritere.subs.push(multicritereCompare);
          multicritere.subs.push(multicritereRetenu);
        }
        if(isRoleExist("HpoRole7_CA")){
          chantiers.subs = chantiers.subs.concat([
            chantiersAutomatique
          ]);
        }
        if(isRoleExist("HpoRole5_AMC")){
          chantiers.subs.push(multicritereCorrespondance);
          chantiers.subs.push(chantiersCreate);
        }
        if(isRoleExist("HpoRole5_AMC") || isRoleExist("HpoRole6_AMCR") || isRoleExist("HpoRole7_CA") || isRoleExist("HpoRole8_CAR")){
          chantiers.subs.push(chantiersListe);
        }
        if(isRoleExist("HpoRole1_D") || isRoleExist("HpoRole2_DR") || isRoleExist("HpoRole8_CAR")){
          navigations.push(title);
        }
        if(isRoleExist("HpoRole1_D")){
          navigations.push(admin);
          navigations.push(data);
        }
        if(isRoleExist("HpoRole1_D") || isRoleExist("HpoRole2_DR") ||isRoleExist("HpoRole3_M")||
          isRoleExist("HpoRole4_MR") || isRoleExist("HpoRole8_CAR")){
          navigations.push(model);
        }
        if(isRoleExist("HpoRole9_OP")){
          navigations.push(leakSeachParent);
        }
        if(isRoleExist("HpoRole10_STRAT")){
          navigations.push(strategic);
        }
        if(isRoleExist("HpoRole11_TACTI")){
          navigations.push(tactical);
        }
        if(isRoleExist("HpoRole5_AMC") || isRoleExist("HpoRole6_AMCR")){
          navigations.push(multicritere);
        }
        if(isRoleExist("HpoRole5_AMC") || isRoleExist("HpoRole6_AMCR") || isRoleExist("HpoRole7_CA") || isRoleExist("HpoRole8_CAR")){
          navigations.push(chantiers);
        }
        if(isRoleExist("HpoRole1_D") || isRoleExist("HpoRole2_DR") ||isRoleExist("HpoRole3_M")||
          isRoleExist("HpoRole5_AMC") || isRoleExist("HpoRole6_AMCR") || isRoleExist("HpoRole7_CA") ||
          isRoleExist("HpoRole4_MR") || isRoleExist("HpoRole8_CAR")){
          return navigations;
        }
      }
    }

    return {
      getUser: getUser,
      getUserRoles: getUserRoles,
      isRootUser: isRootUser,
      getNavigationHpo: getNavigationHpo,
    };
  };
  HpoUserAppFactory.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    '$location',
    'HpoCarteAppFactory',
  ];
  return HpoUserAppFactory;
});
