'use strict';
define(function() {
  var dashboardHpoTabs = function(
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/dashboard_hpo_automatique_tabs.html',
      restrict: 'EA',
      link: function(scope) {
        scope.hpo = {
          pages : [
            {
              label: 'hpo.admin.dashBoardAutomatique.mapping',
            },
            {
              label: 'hpo.admin.dashBoardAutomatique.keyFeatures',
            },
            {
              label: 'hpo.admin.dashBoardAutomatique.completenessCaracteristics',
            },
            {
              label: 'hpo.admin.dashBoardAutomatique.casseHistory'
            }
          ],
          activeTab : 0
        };
        // Précharger complétude dès le chargement de la page
        $timeout(() => {
          scope.$emit("PRELOAD_COMPLETENESS");
        }, 50);
        // Fonction pour redimensionner les graphiques Plotly de ce composant
        function resizePlotlyCharts() {
          if (typeof Plotly === 'undefined') return;
          
          // Sélectionne uniquement les conteneurs de graphiques de ce composant
          const plotlyContainers = document.querySelectorAll('.plotly-chart');
          
          plotlyContainers.forEach(container => {
            if (container && container.id) {
              try {
                // Vérifie si le conteneur est visible
                const isVisible = container.offsetParent !== null;
                if (isVisible) {
                  Plotly.Plots.resize(container);
                }
              } catch (e) {
                console.warn('Erreur lors du redimensionnement du graphique', container.id, e);
              }
            }
          });
        }
        
        // Redimensionner les graphiques quand l'onglet change
        scope.$watch('hpo.activeTab', function(newTab, oldTab) {
          if (newTab !== oldTab) {
            // Utiliser $timeout pour s'assurer que le DOM est mis à jour
            $timeout(function() {
              resizePlotlyCharts();
            }, 100);
          }
        });
        
        // Redimensionner aussi quand la fenêtre change de taille
        angular.element(window).on('resize', function() {
          $timeout(function() {
            // Vérifier que nous sommes sur un onglet qui contient des graphiques
            if (scope.hpo.activeTab !== 0) { // L'onglet 0 est la carte, pas besoin de redimensionner
              resizePlotlyCharts();
            }
          }, 100);
        });
      },
    };
  };

  dashboardHpoTabs.$inject = [
    '$timeout'
  ];
  return dashboardHpoTabs;
});
