'use strict';
define(function() {
  var standardisationDataHpo = function(
    HpoCarteAppFactory,
    HpoAppModelServices,
    $window,
    $filter,
    HpoAppServices,
    AlertHpoFactory,
    gaDomUtils,
    $rootScope,
    ngDialog,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/standardisation_data_hpo.html',
      restrict: 'EA',
      scope: {
        model: '=?',
        uniqueElement: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {


        scope.tabs = [
          {
            title: 'hpo.data.standardisation.configuration.title',
          },
          {
            title: 'hpo.data.standardisation.suivi.title',
          },
        ];
        scope.tabs.activeTab = 0;
        scope.datatableHeight =
          angular.element('.xgos_content').height() - 150 + 'px';
        scope.mapheight = $window.innerHeight - 150 + 'px';
        scope.ftiStandardisation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'hpo_standardisation'
        )[0];
        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';
        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        scope.ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];

        scope.ftis = [];
        scope.standardisation = {
          fti: undefined
        };

        scope.dataVisfeedback = (obj) => {
          scope.objStandardisation = obj;
          ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.standardisationFeedBack.statistique.html',
            className:
              'ngdialog-theme-plain width100 nopadding miniclose',
            scope: scope,
          });
        }
        
        scope.dataVisEnrichment = (obj) => {
          scope.objStandardisation = obj;
          ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.standardisationEnrichment.statistique.html',
            className:
              'ngdialog-theme-plain width100 nopadding miniclose',
            scope: scope,
          });
        } 

        scope.dataVisStandardisation = (obj) => {
          scope.objStandardisation = obj;
          ngDialog.open({
            template:
              'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.standardisation.statistique.html',
            className:
              'ngdialog-theme-plain width100 nopadding miniclose',
            scope: scope,
          });
        }

        scope.redoStandardisation = (obj) => {
          let sendData = {
            ftiStandardisation : scope.ftiStandardisation.uid,
            standardisationObj: obj
          }
          gaDomUtils.showGlobalLoader();
          HpoAppServices.redoStandardisation(sendData).then(
            (res) => {
              gaDomUtils.hideGlobalLoader();
              if (res.data && res.status) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.data.exchange.succes'),
                  $filter('translate')('hpo.model.standardisation.success'),
                  true
                );
                $timeout(function() {
                  scope.refreshData();
                }, 1000);
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            (res) => {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        }

        scope.buttonSpecialActions = [
          {
            class: 'btn btn-success btn-xs',
            icone: 'fa fa-play',
            text: $filter('translate')('hpo.model.calage.rerun'),
            callFunction: scope.redoStandardisation,
            disableFunc: function(obj) {
              if (
                !obj ||
                !obj.properties ||
                !obj.properties.STATUS ||
                obj.properties.STATUS === 'RUNNING'
              )
                return true;
              else return false;
            },
          },
          {
            class: 'btn btn-warning btn-xs',
            icone: 'fa fa-line-chart',
            text: $filter('translate')('hpo.data.standardisation.suivi.feedback'),
            callFunction: scope.dataVisfeedback,
            disableFunc: function (obj) {
              if (
                !obj ||
                !obj.properties ||
                !obj.properties.STATUS ||
                obj.properties.STATUS === 'RUNNING'
              )
                return true;
              else return false;
            },
          },
          {
            class: 'btn btn-default btn-xs',
            icone: 'fa fa-area-chart',
            text: $filter('translate')('hpo.data.standardisation.suivi.enrichment'),
            callFunction: scope.dataVisEnrichment,
            disableFunc: function (obj) {
              if (
                !obj ||
                !obj.properties ||
                !obj.properties.STATUS ||
                obj.properties.STATUS === 'RUNNING'
              )
                return true;
              else return false;
            },
          },
          {
            class: 'btn btn-primary btn-xs',
            icone: 'fa fa-bar-chart',
            text: $filter('translate')('hpo.admin.dashBoardAutomatique.dataVis'),
            callFunction: scope.dataVisStandardisation,
            disableFunc: function (obj) {
              if (
                !obj ||
                !obj.properties ||
                !obj.properties.STATUS ||
                obj.properties.STATUS === 'RUNNING'
              )
                return true;
              else return false;
            },
          }
        ];

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: $filter('translate')('hpo.data.standardisation.suivi.viewTableAndFailure'),
            },
          },
        ];

        scope.editStandardisation = function(obj) {
          if (obj) {
            gaDomUtils.showGlobalLoader();
            HpoAppModelServices.getJeuInformation(
              scope.ftijeudonnee.uid,
              obj.properties.SELECTED_JEU
            ).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  scope.data = HpoCarteAppFactory.getAppFactory().updateFtiWithAttributs(res.data, ['MATAGE']);
                  ngDialog.open({
                    template:
                      'js/XG/widgets/hpoapp/model/views/dialog/hpo.model.jeu.update.html',
                    className:
                      'ngdialog-theme-plain width1100 nopadding miniclose',
                    scope: scope,
                  });
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.$watch('standardisation.selectedjeu', function(newval) {
          if (newval) {
            scope.standardisation.fti = scope.ftis.filter((fti) => {return fti.uid==scope.standardisation.selectedjeu.UID_TABLE_DONNEE})[0];
            var obj = HpoCarteAppFactory.getAppFactory().getAttributesCalage(
              scope.standardisation.fti
            );
            scope.standardisation.variableImputed = {
              id:1,
              leftData: angular.copy(obj.available),
              leftDisplayAttribute: 'alias',
              rightData: angular.copy(obj.required),
              rightDisplayAttribute: 'alias',
              leftTitle: $filter('translate')(
                'hpo.model.calage.attributeavailable'
              ),
              rightTitle: $filter('translate')(
                'hpo.model.calage.attributetouse'
              ),
              source: 'left',
              disableDragFromRight: obj.required.map(function(x) {
                return x.name;
              }),
              keytocheck: 'name',
            };

            scope.standardisation.variableUsedToImpute = {
              id:2,
              leftData: angular.copy(obj.available),
              leftDisplayAttribute: 'alias',
              rightData: angular.copy(obj.required),
              rightDisplayAttribute: 'alias',
              leftTitle: $filter('translate')(
                'hpo.model.calage.attributeavailable'
              ),
              rightTitle: $filter('translate')(
                'hpo.model.calage.attributetouse'
              ),
              source: 'left',
              disableDragFromRight: obj.required.map(function(x) {
                return x.name;
              }),
              keytocheck: 'name',
            };
          }
        });
        

        scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
        scope.translateFtiAttributes = HpoCarteAppFactory.getAppFactory().getTranslateAttributes(
          scope.ftiStandardisation.name
        );
        scope.hideFilter = Object.keys(scope.translateFtiAttributes);

        scope.createtStandardisation = () => {
          let sendData  = Object.assign({}, {
            ftiStandardisation : scope.ftiStandardisation.uid,
            fileMatage: scope.standardisation.fileMatage,
            fileSupersupermod: scope.standardisation.fileSupersupermod,
            enrichCsv: scope.standardisation.enrichCsv,
            enrichZip:scope.standardisation.enrichZip,
            fti : scope.standardisation.fti.uid,
            ftiName : scope.standardisation.fti.name,
            ftidefail : scope.standardisation.selectedjeu.UID_TABLE_FUITE,
            selectedjeu : scope.standardisation.selectedjeu.IDENTIFIANT,
            selectedjeunom : scope.standardisation.selectedjeu.NOM,
            variableImputed: scope.standardisation.variableImputed.rightData.map((obj)=> {return obj.name}).join(),
            variableUsedToImpute: scope.standardisation.variableUsedToImpute.rightData.map((obj)=> {return obj.name}).join(),
            createUser: $rootScope.xgos.user.login
            });
          gaDomUtils.showGlobalLoader();
          HpoAppServices.createtStandardisation(sendData).then(
            function(res) {
              try {
                if (res.data && res.status) {
                  AlertHpoFactory.getSimpleSuccess(
                    $filter('translate')('hpo.common.success')
                  );
                  $rootScope.$broadcast('inititaliseApplicationBranch');
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                console.error(e.stack);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            });
        }

        scope.emptyModel = () => {
          scope.standardisation = {
            fti: undefined,
          };
        }

        scope.downloadStandardisationFile = (documentName) =>{
          HpoAppServices.downloadStandardisationFile(documentName);
        }

        scope.refreshData = function () {
          $rootScope.$broadcast('reloadDatatable', scope.ftiStandardisation.uid);
        };

        scope.datatableCalageCrudHpo = {
          update: { func: scope.editStandardisation },
          remove: true,
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-left',
              func: scope.refreshData,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        scope.postRemove = function(resultat) {
          let identifiants = resultat
            .map(function(x) {
              return x.properties.SELECTED_JEU;
            })
            .join("','");
          HpoCarteAppFactory.getAppFactory().checkDeleteModel(identifiants);
          $rootScope.$broadcast('inititaliseApplicationBranch');
        }

      },
    };
  };

  standardisationDataHpo.$inject = [
    'HpoCarteAppFactory',
    'HpoAppModelServices',
    '$window',
    '$filter',
    'HpoAppServices',
    'AlertHpoFactory',
    'gaDomUtils',
    '$rootScope',
    'ngDialog',
    '$timeout',
  ];
  return standardisationDataHpo;
});
