'use strict';
define(function() {
  var multicritereRetenuReport = function(
    HpoCarteAppFactory,
    $filter,
    QueryFactory,
    HpoMulticritereServices,
    chartFactory,
    gaDomUtils
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/analye_multicritere/views/directives/multicritere_retenu_report.html',
      restrict: 'EA',
      scope: {
        res: '=?',
      },
      link: (scope) => {
        scope.ftiCompare = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'compare'
        )[0];
        let fti_ponderation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'ponderation'
        )[0];
        let fti_indicateur = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'indicateur'
        )[0];
        let fti_critereas = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'critereas'
        )[0];
        let fti_filter = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'amc_filter'
        )[0];
        let reportBilanName = HpoCarteAppFactory.getAppFactory().getReportBilanName(
          'docx'
        )[0];
        scope.compareList = [];
        scope.reportData = {
          docx: reportBilanName,
          priority:scope.res,
          ftiFilter:fti_filter.uid,
          ftiPonderation:fti_ponderation.uid,
          ftiCritereas:fti_critereas.uid,
          ftiIndicateur:fti_indicateur.uid,
          addJeuDonnee:true
        }
        scope.report_description = $filter('translate')('hpo.multicritere.retenu.report.description');
        QueryFactory.data(scope.ftiCompare.uid).then((compareFC)=>{
          if(compareFC && compareFC.data){
            compareFC.data.features.forEach((feat) => {
              HpoMulticritereServices.getComparaison(
                scope.ftiCompare.uid,
                feat.id
              ).then((compareFeat) =>{
                  if (compareFeat && compareFeat.data) {
                    if(Object.keys(compareFeat.data.ponderation).includes(scope.res.data.ponderation)){
                      scope.compareList.push(compareFeat.data);
                    }
                  }
              });
            })
          }
        });

        // préparation des données des graphiques
        scope.$watch('reportData.compare',()=>{
          if(scope.reportData.compare){
            scope.reportData.compare.chartOpt = chartFactory.getLineOption(
              500,
              450
            );
            scope.reportData.compare.chartOpt.chart.xAxis.axisLabel = $filter(
              'translate'
            )('hpo.multicritere.compare.chartXtitle');
            scope.reportData.compare.chartOpt.chart.xAxis.tickSize = 6;
            scope.reportData.compare.chartOpt.chart.xAxis.domain = [
              0,
              1,
            ];
            scope.reportData.compare.chartOpt.chart.xAxis.range = [0, 1];
            scope.reportData.compare.chartOpt.chart.xAxis.showMaxMin = false;
            scope.reportData.compare.chartOpt.chart.xAxis.showLabels = false;
            scope.reportData.compare.chartOpt.chart.xAxis.tickFormat = function(
              d
            ) {
              if (
                d !== 0 &&
                d - 1 <= scope.reportData.compare.result.labels.length
              )
                return scope.reportData.compare.result.labels[d - 1];
              else {
                return d;
              }
            };
            
            scope.reportData.compare.chartOpt.chart.xAxis.staggerLabels = true;
            scope.reportData.compare.chartOpt.chart.xAxis.rotateYLabel = false;
            scope.reportData.compare.chartOpt.chart.xAxis.axisLabelDistance = 7;
            scope.reportData.compare.chartOpt.chart.xAxis.ticks =
              scope.reportData.compare.result.labels.length + 1;
            scope.reportData.compare.chartOpt.chart.yAxis.ticks = 2;
            scope.reportData.compare.chartOpt.chart.yAxis.domain = [
              0,
              100,
            ];
            scope.reportData.compare.chartOpt.chart.yAxis.range = [
              0,
              100,
            ];
            scope.reportData.compare.chartOpt.chart.forceY = [
              0,
              scope.reportData.compare.result[
                'y_' + scope.reportData.compare.indicateurresult
              ],
            ];
            scope.reportData.compare.chartOpt.chart.forceX = [
              0,
              scope.reportData.compare.result.x,
            ];
            scope.reportData.compare.chartOpt.chart.yAxis.showMaxMin = false;
            scope.reportData.compare.chartOpt.chart.yAxis.axisLabel = $filter(
              'translate'
            )('hpo.multicritere.compare.chartYtitle');
            scope.reportData.compare.chartOpt.chart.showLegend = true;
            scope.reportData.compare.chartOpt.title.enable = true;
            scope.reportData.compare.chartOpt.title.className = 'h4';
            scope.reportData.compare.chartOpt.title.text =
              $filter('translate')(
                'hpo.multicritere.compare.charttitle'
              ) +
              ' ' +
              scope.reportData.compare.seuil +
              $filter('translate')(
                'hpo.multicritere.compare.charttitlesub'
              );

            scope.reportData.compare.chartOpt2 = angular.copy(scope.reportData.compare.chartOpt);
            scope.reportData.compare.chartOpt2.chart.yAxis.axisLabel = $filter(
              'translate'
            )('hpo.multicritere.compare.chartYtitle2');
          }
        })

        scope.generateReport = () => {
          gaDomUtils.showGlobalLoader();
          HpoMulticritereServices.generateReport(
            scope.reportData
          ).then((res) =>{
            window.open(
              '/services/' +
                angular.module('gcMainHpo').portalid +
                '/documents/downloaddocx?' +
                '&name=' +
                res.data.name
            );
            gaDomUtils.hideGlobalLoader();
          }, () =>{
            gaDomUtils.hideGlobalLoader();
          })
        }
       
      }
       

    };
  };

  multicritereRetenuReport.$inject = [
    'HpoCarteAppFactory',
    '$filter',
    'QueryFactory',
    'HpoMulticritereServices',
    'chartFactory',
    'gaDomUtils'
  ];
  return multicritereRetenuReport;
});
