'use strict';
define(function() {
  var ancBacFacturationConfiguration = function(
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    ngDialog,
    $filter,
    $sce,
    $rootScope,
    $http,
    dolibarrFactory,
    FeatureTypeFactory,
    QueryFactory,
    $q,
    $window
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_facturation_configuration.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        //console.log(scope.apptype)
        scope.xgos = $rootScope.xgos;

        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;

        var loadConfig = function() {
          scope.periodesCfg = angular.copy(
            CurrentAppFactory.appCfg.main.periodesCfg
          );
        };

        loadConfig();

        scope.$on('checkIfDirtyFacturationCfg', function() {
          scope.saveFacturationPeriodeCfg(true);
        });

        scope.crudElement = function(element, id) {
          if (id == -1) {
            scope.periodesCfg.tarification.push(element);
          } else if (angular.isDefined(periode.dolibarrId)) {
            scope.periodesCfg.tarification[id] = element;
          }
        };

        /**
         * activateDolibarr
         */
        scope.activateDolibarr = function() {
          var ans = confirm(
            'Êtes-vous sur de vouloir basculer en mode de facturation Dolibarr ?'
          );
          if (ans) {
            CurrentAppFactory.appCfg.main.properties.dolibarr.active = true;
            CurrentAppFactory.updateAppCfg().then(function() {
              $window.location.reload();
            });
          }
        };

        /**
         * saveFacturationPeriodeCfg
         * save tout
         */
        scope.saveFacturationPeriodeCfg = function(checkDirty) {
          if (angular.isDefined(checkDirty) && checkDirty) {
            if (
              !angular.equals(
                scope.periodesCfg,
                CurrentAppFactory.appCfg.main.periodesCfg
              )
            )
              var ans = confirm(
                'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
              );
          }
          if (angular.isUndefined(checkDirty) || (checkDirty && ans)) {
            CurrentAppFactory.appCfg.main.periodesCfg = scope.periodesCfg;
            CurrentAppFactory.updateAppCfg().then(function() {});
          } else if (checkDirty && !ans) {
            loadConfig();
          }
        };
      },
    };
  };

  ancBacFacturationConfiguration.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    'ngDialog',
    '$filter',
    '$sce',
    '$rootScope',
    '$http',
    'dolibarrFactory',
    'FeatureTypeFactory',
    'QueryFactory',
    '$q',
    '$window',
  ];
  return ancBacFacturationConfiguration;
});
