'use strict';
define(function() {
  var ancBacControleConfiguration = function(
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    ngDialog,
    $rootScope,
    gaJsUtils,
    DocumentFactory,
    $window,
    FeatureTypeFactory,
    ancBacTools, PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_controle_configuration.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.xgos = $rootScope.xgos;
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;

        if (scope.apptype == 'bac') {
          scope.controleName = 'Instruction';
          scope.complementAppartenance = "d'";
          scope.feminin = 'e';
        } else {
          scope.controleName = 'Contrôle';
          scope.complementAppartenance = 'de ';
        }

        /*----------------------------------------------
         * CONTROLE
         *---------------------------------------------*/

        var loadConfig = function() {
          scope.controletype = angular.copy(
            CurrentAppFactory.appCfg.main.controleCfg
          );
          if (scope.apptype !== 'bac') {
            scope.vidanges_types = angular.copy(
              CurrentAppFactory.appCfg.main.properties.vidangeDocumentsCfg
                .document_types
            );
            scope.subventionActive = angular.copy(
              CurrentAppFactory.appCfg.main.properties.subventionnableDossier
            );
            scope.subvention_types = angular.copy(
              CurrentAppFactory.appCfg.main.properties.subventionDocumentsCfg
                .document_types
            );
            scope.bkpvidanges_types = angular.copy(
              CurrentAppFactory.appCfg.main.properties.vidangeDocumentsCfg
                .document_types
            );
            scope.bkpsubvention_types = angular.copy(
              CurrentAppFactory.appCfg.main.properties.subventionDocumentsCfg
                .document_types
            );
          }
          scope.controlesWorkflow = angular.copy(
            CurrentAppFactory.appCfg.main.controleWorkflowCfg
          );
          scope.setIfFalse = () => {
            scope.controlesWorkflow.forEach(function (controle) {
              if (!controle.delai) {
                controle.delai = {};
              }
            });
          };
          scope.setIfFalse();
          scope.avisCtrl = angular.copy(
            CurrentAppFactory.appCfg.main.dossierCfg.avisControles
          );

          scope.bkpAvisCtrl = angular.copy(
            CurrentAppFactory.appCfg.main.dossierCfg.avisControles
          );
          scope.bkpControlesWorkflow = angular.copy(
            CurrentAppFactory.appCfg.main.controleWorkflowCfg
          );
          scope.bkpControleType = angular.copy(
            CurrentAppFactory.appCfg.main.controleCfg
          );
          if (scope.apptype == 'anc') {
            AncAppFactory.getElementFiliereData('element').then(function(res) {
              scope.listeElementsFilieres = res.data.features;
            });
          }
        };

        loadConfig();

        scope.$on('checkIfDirtyControleCfg', function() {
          scope.enregistrerCfgControle(true);
        });

        var testIfModified = function(tmpData, tmpNewData) {
          var cleanData = gaJsUtils.removeEmpty(tmpData, true);
          var cleanNewData = gaJsUtils.removeEmpty(tmpNewData, true);
          return JSON.stringify(cleanData) != JSON.stringify(cleanNewData);
        };

        scope.enregistrerCfgControle = function(checkDirty) {
          if (angular.isDefined(checkDirty) && checkDirty) {
            if (
              testIfModified(scope.avisCtrl, scope.bkpAvisCtrl) ||
              testIfModified(
                scope.controlesWorkflow,
                scope.bkpControlesWorkflow
              ) ||
              testIfModified(scope.controletype, scope.bkpControleType) ||
              testIfModified(scope.vidanges_types, scope.bkpvidanges_types) ||
              testIfModified(scope.subvention_types, scope.bkpsubvention_types)
            )
              var ans = confirm(
                'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
              );
          }

          if (
            (angular.isUndefined(checkDirty) &&
              confirm(
                'Êtes vous certain de vouloir mettre à jour la configuration des ' +
                  scope.controleName.toLowerCase() +
                  's ?'
              )) ||
            (checkDirty && ans)
          ) {
            if (scope.avisCtrl) {
              CurrentAppFactory.appCfg.main.dossierCfg.avisControles =
                scope.avisCtrl;
            }
            if (scope.controlesWorkflow) {
              CurrentAppFactory.appCfg.main.controleWorkflowCfg =
                scope.controlesWorkflow;
            }
            if (scope.controletype) {
              CurrentAppFactory.appCfg.main.controleCfg = scope.controletype;
            }
            if (scope.apptype !== 'bac') {
              CurrentAppFactory.appCfg.main.properties.vidangeDocumentsCfg.document_types =
                scope.vidanges_types;
            }
            if (scope.apptype !== 'bac') {
              CurrentAppFactory.appCfg.main.properties.subventionDocumentsCfg.document_types =
                scope.subvention_types;
            }
            CurrentAppFactory.updateAppCfg().then(function() {
              loadConfig();
            });
          } else if (checkDirty && !ans) {
            loadConfig();
          }
        };

        /**
         * Acces à la gestion des évenements de l'administration
         */
        scope.goToGestionCalendar = function() {
          $window.open('#/calendar/');
        };
        /**
         * Acces à la gestion des modèles de l'administration
         */
        scope.goToGestionModeles = function() {
          $window.open('#/documents/');
        };

        // ouvrirFormulaireTemplateDialog
        var nouveauFormulaireTemplateDialog;
        scope.ouvrirFormulaireTemplateDialog = function() {
          nouveauFormulaireTemplateDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.nouveauFormulaireTemplateDialog.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        // nouveau controletype
        scope.nouveauEmplacementFormulaire = function(nouveauEmplacement) {
          if (
            angular.isUndefined(nouveauEmplacement) ||
            angular.isUndefined(nouveauEmplacement.label) ||
            angular.isUndefined(nouveauEmplacement.type) ||
            nouveauEmplacement.label == '' ||
            nouveauEmplacement.type == ''
          ) {
            require('toastr').error('Il manque des informations.');
            return false;
          }

          if (angular.isUndefined(nouveauEmplacement.document_types)) {
            nouveauEmplacement.document_types = [];
          }

          scope.controletype.push(nouveauEmplacement);
          nouveauFormulaireTemplateDialog.close();
        };

        scope.supprimerDocumentType = function(rownIndex, columnIndex, type) {
          if (!angular.isDefined(type)) {
            require('toastr').error(
              'Il manque le type de document à supprimer. '
            );
            return;
          }
          let reponseConfirmation = false;
          switch (type) {
            case 'documents':
              reponseConfirmation = confirm(
                'Êtes-vous sûr de vouloir supprimer ce document type ?'
              );
              if (reponseConfirmation == true) {
                scope.controletype[rownIndex].document_types.splice(
                  columnIndex,
                  1
                );
              }
              break;
            case 'subventions':
              reponseConfirmation = confirm(
                'Êtes-vous sûr de vouloir supprimer cette subvention ?'
              );
              if (reponseConfirmation == true) {
                scope.subvention_types.splice(columnIndex, 1);
              }
              break;
            case 'vidanges':
              reponseConfirmation = confirm(
                'Êtes-vous sûr de vouloir supprimer ce vidange ?'
              );
              if (reponseConfirmation === true) {
                scope.vidanges_types.splice(columnIndex, 1);
              }
              break;
            default:
              require('toastr').error(
                'Type de document à supprimer est inconnu .'
              );
              break;
          }
        };
        // Dialog documentTypeDialog
        var documentTypeDialog, currentRownIndex, currentColumnIndex;
        scope.ouvrirDocumentTypeDialog = function(
          rownIndex,
          columnIndex,
          currentDocumentType
        ) {
          currentRownIndex = rownIndex;

          scope.currentDocumentType = {};

          if (currentDocumentType) {
            scope.currentDocumentType = angular.copy(currentDocumentType);
            currentColumnIndex = columnIndex;
          }
          documentTypeDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.documentTypeDialog.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        // Dialog documentTypeDialog
        var documentTypeDialogVidange;
        scope.ouvrirDocumentVidangeDialog = function(
          rownIndex,
          currentDocumentType
        ) {
          if (rownIndex) {
            scope.indexVidange = rownIndex;
          } else {
            if (scope.vidanges_types) {
              scope.indexVidange = scope.vidanges_types.length;
            } else {
              scope.indexVidange = 0;
            }
          }
          scope.currentDocumentType = {};
          if (currentDocumentType) {
            scope.currentDocumentType = angular.copy(currentDocumentType);
          }
          documentTypeDialogVidange = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.documentTypeDialog.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.saveCurrentDocumentVidangeType = function() {
          if (scope.vidanges_types) {
            scope.indexVidange = scope.vidanges_types.length;
          } else {
            scope.vidanges_types = [];
            scope.indexVidange = 0;
          }
          scope.vidanges_types[scope.indexVidange] = scope.currentDocumentType;
          documentTypeDialogVidange.close();
        };
        // Dialog documentTypeDialog
        var documentTypeDialogSubvention;
        scope.ouvrirDocumentSubventionDialog = function(
          rownIndex,
          currentDocumentType
        ) {
          if (rownIndex) {
            scope.indexSubvention = rownIndex;
          } else {
            if (scope.subvention_types) {
              scope.indexSubvention = scope.subvention_types.length;
            } else {
              scope.indexSubvention = 0;
            }
          }
          scope.currentDocumentType = {};
          if (currentDocumentType) {
            scope.currentDocumentType = angular.copy(currentDocumentType);
          }
          documentTypeDialogSubvention = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.documentTypeDialog.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.saveCurrentDocumentSubventionType = function() {
          if (scope.subvention_types) {
            scope.indexSubvention = scope.subvention_types.length;
          } else {
            scope.indexSubvention = 0;
          }
          scope.subvention_types[scope.indexSubvention] =
            scope.currentDocumentType;
          documentTypeDialogSubvention.close();
        };

        /**
         * check Enchainement
         *
         * @param Enchainement
         */
        scope.checkEnchainement = function(enchainement, type, index) {
          /*
           * for (var i = 0; i < scope.controlesWorkflow.length; i++) { if
           * (scope.controlesWorkflow[i].current_controle ==
           * enchainement.current_controle && scope.controlesWorkflow[i].avis ==
           * enchainement.avis && index != i) { var r = confirm('Un
           * enchaînement de contrôle existe déjà pour ce type de contrôle et
           * cet avis.\n Etes vous sur de vouloir continuer ? '); } }
           */
        };

        // supprimer un controle
        scope.supprimerControle = function(index) {
          var r = confirm(
            'Êtes-vous sûr de vouloir supprimer cet enchainement ' +
              scope.complementAppartenance +
              '' +
              scope.controleName.toLowerCase() +
              ' ?'
          );
          if (r == true) {
            scope.controlesWorkflow.splice(index, 1);
          }
        };

        scope.delaitypes = ['jour', 'semaine', 'mois', 'année'];

        // Supprimer ControleType
        scope.supprimerControleType = function(index) {
          var r = confirm(
            'Êtes-vous sûr de vouloir supprimer ce type ' +
              scope.complementAppartenance +
              '' +
              scope.controleName.toLowerCase() +
              '?'
          );
          if (r == true) {
            CurrentAppFactory.appCfg.main.controleCfg.splice(index, 1);
            scope.controletype.splice(index, 1);
          }
        };

        scope.returnAvisCtrl = function() {
          return scope.avisCtrl;
        };

        var nouveauControleDialog;
        scope.ouvrirControleDialog = function() {
          scope.nouveauControle = {};
          nouveauControleDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.nouveauControleDialog.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        // ajouter un controle
        scope.ajouterNouveauWorflowControle = function(nouveauControle) {
          if (validateNouveauWorflowControle(nouveauControle)){
            scope.controlesWorkflow.push(nouveauControle);
            nouveauControleDialog.close();
          }
        };

        scope.checkIfAvisIsActif = function() {
          scope.controlesWorkflow.forEach(function(y, i) {
            scope.avisCtrl.map(function(x) {
              if (x.key == y.avis && x.type_controle == y.current_controle) {
                if (
                  angular.isUndefined(x.actif) ||
                  (angular.isDefined(x.actif) && x.actif == false)
                ) {
                  scope.controlesWorkflow[i].isInactive = true;
                } else if (
                  angular.isDefined(scope.controlesWorkflow[i].isInactive)
                ) {
                  delete scope.controlesWorkflow[i].isInactive;
                }
              }
            });
          });
        };

        scope.$watch(
          'nouveauControle.avis',
          function(avis) {
            if (avis) {
              scope.avisCtrl.forEach(function(k) {
                if (k.key == avis) {
                  if (angular.isDefined(k.actif) && !k.actif) {
                    scope.isInactif = true;
                  } else {
                    scope.isInactif = false;
                  }
                }
              });
            }
          },
          1
        );

        /*----------------------------------------------
         * AVIS
         *---------------------------------------------*/

        // Bouton ajouter un avis
        var nouveauAvisDialog;
        scope.ouvrirAvisDialog = function() {
          console.log(scope.apptype);
          nouveauAvisDialog = ngDialog.open({
            template:
              'js/XG/widgets/' +
              scope.apptype +
              'app/main/views/modals/modal.nouveauAvisDialog.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        function slug(value) {
          var rExps = [
            { re: /[\xC0-\xC6]/g, ch: 'A' },
            { re: /[\xE0-\xE6]/g, ch: 'a' },
            { re: /[\xC8-\xCB]/g, ch: 'E' },
            { re: /[\xE8-\xEB]/g, ch: 'e' },
            { re: /[\xCC-\xCF]/g, ch: 'I' },
            { re: /[\xEC-\xEF]/g, ch: 'i' },
            { re: /[\xD2-\xD6]/g, ch: 'O' },
            { re: /[\xF2-\xF6]/g, ch: 'o' },
            { re: /[\xD9-\xDC]/g, ch: 'U' },
            { re: /[\xF9-\xFC]/g, ch: 'u' },
            { re: /[\xC7-\xE7]/g, ch: 'c' },
            { re: /[\xD1]/g, ch: 'N' },
            { re: /[\xF1]/g, ch: 'n' },
          ];

          // converti les caractères accentués en leurs équivalent
          // alpha
          for (var i = 0, len = rExps.length; i < len; i++)
            value = value.replace(rExps[i].re, rExps[i].ch);

          // 1) met en bas de casse
          // 2) remplace les espace par des tirets
          // 3) enleve tout les caratères non alphanumeriques
          // 4) enlève les doubles tirets
          return value
            .toLowerCase()
            .replace(/\s+/g, '-')
            .replace(/[^a-z0-9-]/g, '')
            .replace(/\-{2,}/g, '-');
        }

        scope.avisFilter = {};
        scope.ajouterNouveauAvisControle = function(nouveauAvis) {
          /*
           * if (angular.isUndefined(nouveauAvis)) {
           * require('toastr').error("Il manque des informations."); return
           * false; }
           */

          // retrieve max id from json
          var maxId = 0;
          if (scope.avisCtrl.length) {
            maxId = Math.max(
              ...scope.avisCtrl
              .map(avis => avis.id)
              .filter(id => id != undefined)
              );
          }

          nouveauAvis.id = maxId + 1;
          nouveauAvis.label_initial = nouveauAvis.label;
          nouveauAvis.default = false;
          nouveauAvis.actif = true;
          nouveauAvis.key = nouveauAvis.label + '_TCONTROLE_' + nouveauAvis.type_controle

          scope.avisCtrl.push(nouveauAvis);
          nouveauAvisDialog.close();
        };

        scope.supprimerAvis = function(index) {
          var r = confirm('Êtes-vous sûr de vouloir supprimer cet avis?');
          if (r == true) {
            scope.avisCtrl.splice(index, 1);
          }
        };

        /*
         * GET LIST FILES
         */

        scope.refreshTemplatesList = function(loader) {
          if (loader) gaDomUtils.showGlobalLoader();
          DocumentFactory.getlisttemplate().then(function(res) {
            scope.listTemplates = res.data;
            if (loader) gaDomUtils.hideGlobalLoader();
          });
        };
        scope.refreshTemplatesList(0);

        /**
         *
         */
        var addDocModal;
        scope.addDocumentFromApp = function() {
          addDocModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.addDocument.html',
            className: 'ngdialog-theme-plain width300 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            preCloseCallback: function() {
              scope.refreshTemplatesList(true);
            },
          });
        };

        scope.closeAddDoc = function() {
          addDocModal.close();
        };

        /**
         * docfeeder prefill docfeeder data so it can be displayed
         *
         * @param type
         * @param mode
         */
        scope.docfeeder = function(type, mode) {
          if (!mode) mode = 'feeder';

          var label_controle_feeder = 'Contrôles ANC';
          var label_autre_feeder = 'Autres données ANC';
          var label_dossier_feeder = 'Informations du dossier';

          // user local session storage to store the tree
          var ctrlbranches = [];
          var listElementWithAttribute = [];
          if (scope.apptype == 'bac') {
            CurrentAppFactory.appCfg.main.controleCfg.forEach(function(x) {
              ctrlbranches.push({
                label: x.label,
                type: x.type,
                jsonurl: BacAppFactory.getextractedjsondataurl(
                  x.type,
                  scope.apptype
                ),
              });
            });
            label_controle_feeder = 'Instructions BAC';
            label_autre_feeder = 'Autres données BAC';
          } else {
            AncAppFactory.appCfg.main.controleCfg.forEach(function(x) {
              // if(x.type.indexOf('_mutation')==-1){
              ctrlbranches.push({
                label: x.label_court,
                type: x.type,
                jsonurl: AncAppFactory.getextractedjsondataurl(x.type),
              });
              // }
            });

            scope.listeElementsFilieres.map(function(element) {
              var element_attribute = angular.copy(
                FeatureTypeFactory.getFeatureByUid(
                  element.properties.identifiant
                )
              );
              if (element_attribute != null) {
                element_attribute.type = element.properties.id_type;
                listElementWithAttribute.push(element_attribute);
              }
            });
          }

          var kisfeeder = {
            branches: [],
            mode: mode,
            appname: CurrentAppFactory.appCfg.appname,
          };

          if (type == 'controle') {
            kisfeeder.branches.push({
              label: label_controle_feeder,
              children: ctrlbranches,
            });

            kisfeeder.branches.push({
              label: label_dossier_feeder,
              jsonurl: scope.apptype + '/dossiers.json',
              extraFields: ancBacTools.getDossierExtraFields(
                CurrentAppFactory.appCfg.main.datastore,
                scope.apptype
              ),
              type: 'type_dossier_feeder',
            });

            // ssi vidange activée sur le portail
            if (
              scope.apptype !== 'bac' &&
              CurrentAppFactory.appCfg.main.properties.formVidange == true
            ) {
              kisfeeder.branches.push({
                label: 'Vidanges',
                jsonurl: AncAppFactory.getextractedjsondataurl(
                  'vidange_formulaire',
                  scope.apptype
                ),
                type: 'wwwwwwwwwwwwwwwwwwwwwwww',
              });
            }
            // ssi vidange activée sur le portail
            if (
              scope.apptype !== 'bac' &&
              CurrentAppFactory.appCfg.main.properties.subventionnableDossier ==
                true
            ) {
              kisfeeder.branches.push({
                label: 'Subventions',
                jsonurl: AncAppFactory.getextractedjsondataurl(
                  'subvention_formulaire',
                  scope.apptype
                ),
                type: 'wwwwwwwwwwwwwwwwwwwwwwww',
              });
            }

            if (mode == 'feeder' && scope.apptype != 'bac') {
              kisfeeder.branches.push({
                label: 'Elements de filière',
                jsonurl: 'elements_filiere.json',
                type: 'elements_filiere_templater',
              });
            }

            if (mode == 'discriminant' && scope.apptype != 'bac') {
              kisfeeder.branches.push({
                label: 'Elements de filière',
                jsonurl: 'elements_filiere.json',
                type: 'elements_filiere_commentaire',
              });
            }
          }

          // if (mode == "feeder") {
          kisfeeder.branches.push({
            label: label_autre_feeder,
            jsonurl: scope.apptype + '/general.json',
            type: 'type_autre_feeder',
          });
          // }

          localStorage.setItem('kisfeeder', JSON.stringify(kisfeeder));

          localStorage.setItem(
            'kisTypeFormulaire',
            JSON.stringify(scope.controletype)
          );

          // anc only
          if (scope.apptype == 'anc') {
            localStorage.setItem(
              'kisFeederCfgAppli',
              JSON.stringify(AncAppFactory.appCfg.main)
            );
            localStorage.setItem(
              'kisElementFiliereFeeder',
              JSON.stringify(listElementWithAttribute)
            );
          }

          gaJsUtils.openNewWindowDS(
            'js/XG/modules/common/docxfeeder/feeder.html?portalId=' + PortalsFactory.getPortalId(),
            'KIS ANC',
            1200,
            window.innerHeight
          );
        };

        scope.saveCurrentDocumentType = function() {
          if (scope.indexVidange !== undefined) {
            scope.saveCurrentDocumentVidangeType();
          } else if (scope.indexSubvention !== undefined) {
            scope.saveCurrentDocumentSubventionType();
          } else {
            if (currentColumnIndex == undefined) {
              scope.controletype[currentRownIndex].document_types.push(
                scope.currentDocumentType
              );
            } else {
              scope.controletype[currentRownIndex].document_types[
                currentColumnIndex
              ] = scope.currentDocumentType;
            }
            currentColumnIndex = undefined;
            currentRownIndex = undefined;
            documentTypeDialog.close();
          }
        };

        scope.changeCtrlForm = function(pananc) {
          if (pananc === true) {
            if (
              !angular.equals(
                CurrentAppFactory.appCfg.main.controleCfg,
                CurrentAppFactory.getPanancCfg()
              )
            ) {
              var r = confirm(
                'Êtes vous certain de vouloir remplacer la configuration actuelle des ' +
                  scope.controleName.toLowerCase() +
                  's avec la configuration PANANC ?\nCela réinitialisera la configuration.'
              );
              if (r == true) {
                scope.controletype = [];
                CurrentAppFactory.appCfg.main.controleCfg = CurrentAppFactory.getPanancCfg();
                scope.controletype = CurrentAppFactory.appCfg.main.controleCfg;
                console.log(pananc);
              }
            } else {
              require('toastr').error('Configuration déjà chargée.');
            }
          } else if (pananc === false) {
            if (
              !angular.equals(
                CurrentAppFactory.appCfg.main.controleCfg,
                CurrentAppFactory.getStandardCfg()
              )
            ) {
              var r = confirm(
                'Êtes vous certain de vouloir remplacer la configuration actuelle des ' +
                  scope.controleName.toLowerCase() +
                  's avec la configuration Standard ?\nCela réinitialisera la configuration.'
              );
              if (r == true) {
                scope.controletype = [];
                CurrentAppFactory.appCfg.main.controleCfg = CurrentAppFactory.getStandardCfg();
                scope.controletype = CurrentAppFactory.appCfg.main.controleCfg;
                console.log(pananc);
              }
            } else {
              require('toastr').error('Configuration déjà chargée.');
            }
          }
        };

        /**
         * moveDocumentType
         *
         * @param {*}
         *            document_types
         * @param {*}
         *            index
         * @param {*}
         *            direction
         */
        scope.moveDocumentType = function(document_types, index, direction) {
          gaJsUtils.moveElementInArray(document_types, index, direction);
        };
        /**
         * validatation d'un NouveauWorflowControle
         * @param {*} nouveauWorflowControle
         */
        let validateNouveauWorflowControle = function(nouveauWorflowControle) {
          if (
            !nouveauWorflowControle ||
            !nouveauWorflowControle.current_controle ||
            !nouveauWorflowControle.avis ||
            !nouveauWorflowControle.next_controle ||
            (nouveauWorflowControle.avec_delai &&
              (!nouveauWorflowControle.delai ||
                !nouveauWorflowControle.delai.value |
                  !nouveauWorflowControle.delai.type))
          ) {
            require('toastr').error('Pour la configuration WorflowControle : Il manque des informations.');
            return false;
          }
          return true;
        };
      },
    };
  };

  ancBacControleConfiguration.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    'ngDialog',
    '$rootScope',
    'gaJsUtils',
    'DocumentFactory',
    '$window',
    'FeatureTypeFactory',
    'ancBacTools', 'PortalsFactory'
  ];
  return ancBacControleConfiguration;
});
