'use strict';
define(function() {
  var ancAjoutElementFiliere = function(
    AncAppFactory,
    gaDomUtils,
    EditFactory,
    $rootScope,
    FeatureTypeFactory,
    $q,
    gaJsUtils
  ) {
    /**
     * permet d'ajouter un element de filiere que ce soit depuis la filiere
     * ou le controle
     */
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_ajout_element_filiere.html',
      restrict: 'EA',
      scope: {
        currentFiliere: '=',
        selectedFiliere: '=?',
        typeControle: '=?',
        depuisControle: '=?',
        controleCommentConfig: '=?',
        typeControleNom: '=?',
      },
      link: function(scope) {
        /*----------------------------------------------
         * FILIERES
         *---------------------------------------------*/

        var groupes;

        scope.newFiliereElement = {};

        $q.all([
          AncAppFactory.getElementFiliereData('groupe'),
          AncAppFactory.getElementFiliereData('type'),
          AncAppFactory.getElementFiliereData('element'),
        ]).then(function(res) {
          groupes = res[0].data.features;
          scope.listeGroupeFilieres = groupes;
          scope.newFiliereElement.groupe = groupes[0].id;

          scope.listeTypeFilieres = res[1].data.features;
          scope.listeElementsFilieres = res[2].data.features;
        });

        /**
         * Retrieve available filieres types
         *
         * @returns {Array}
         */
        scope.availableTypesFiliere = function() {
          var available = [];
          if (scope.newFiliereElement.groupe) {
            scope.listeTypeFilieres.forEach(function(f) {
              if (f.properties.id_groupe == scope.newFiliereElement.groupe) {
                available.push(f);
              }
            });
          }
          if (available.length == 1)
            scope.newFiliereElement.type = available[0].id;
          return available;
        };

        /**
         * Retrieve available filieres elements
         *
         * @returns {Array}
         */
        scope.availableElementsFiliere = function() {
          var available = [];
          if (scope.newFiliereElement.groupe) {
            scope.listeElementsFilieres.forEach(function(f) {
              if (f.properties.id_type == scope.newFiliereElement.type) {
                available.push(f);
              }
            });
            available.sort(function(a, b) {
              return a.properties.alias.localeCompare(b.properties.alias);
            });
          }
          return available;
        };

        /**
         * resetLinkedElement
         */
        var resetLinkedElement = function(uid) {
          uid = uid || false;
          scope.newFiliereElement.linked_element = {};
          scope.newFiliereElement.linked_uid = uid;
        };

        /**
         * changeGroup
         */
        scope.changeGroup = function() {
          delete scope.newFiliereElement.type;
          delete scope.newFiliereElement.element;
          resetLinkedElement();
        };
        /**
         * changeType
         */
        scope.changeType = function() {
          delete scope.newFiliereElement.element;
          resetLinkedElement();
        };
        /**
         * changeElement
         */
        scope.changeElement = function() {
          resetLinkedElement(
            FeatureTypeFactory.getFeatureByNameAndDatastore(
              AncAppFactory.appCfg.main.datastore,
              scope.newFiliereElement.element.properties.identifiant
            )['uid']
          );
        };

        /**
         * addElementToFiliere
         */
        scope.addElementToFiliere = function() {
          if (scope.currentFiliere !== undefined) {
            var featureCollection = {
              type: 'FeatureCollection',
              features: [
                {
                  type: 'Feature',
                  properties: scope.newFiliereElement.linked_element.properties,
                },
              ],
            };

            if (
              gaJsUtils.checkNestedProperty(
                'selectedFiliere.properties.etat',
                scope
              )
            ) {
              featureCollection.features[0].properties.filiere_active =
                scope.selectedFiliere.properties.etat == 'active'
                  ? true
                  : false;
              featureCollection.features[0].properties.id_filiere =
                scope.currentFiliere.id;
              console.log(featureCollection);
            } else if (
              gaJsUtils.checkNestedProperty(
                'currentFiliere.properties.etat',
                scope
              )
            ) {
              featureCollection.features[0].properties.filiere_active =
                scope.currentFiliere.properties.etat == 'active' ? true : false;
              featureCollection.features[0].properties.id_filiere =
                scope.currentFiliere.id;
              console.log(featureCollection);
            } else {
              featureCollection.features[0].properties.filiere_active = false;
              console.log(featureCollection);
            }

            gaDomUtils.showGlobalLoader();

            EditFactory.add(
              scope.newFiliereElement.linked_uid,
              featureCollection,
              ''
            ).then(function(res) {
              var ftid = res.data.create[0].id;

              if (
                angular.isUndefined(scope.selectedFiliere) ||
                scope.selectedFiliere === false
              )
                scope.selectedFiliere = scope.currentFiliere.id;

              AncAppFactory.addelementtofiliere(
                scope.selectedFiliere,
                scope.newFiliereElement.linked_uid,
                ftid
              ).then(function(res) {
                $rootScope.$broadcast('refreshRepresentationDisplayElements', {
                  uid: scope.newFiliereElement.linked_uid,
                  featureCollection: featureCollection,
                  ftid: ftid,
                });

                gaDomUtils.hideGlobalLoader();

                var resetDossierData = {
                  doNotTriggerDirtyRF: true,
                  doNotResetCtrl: scope.depuisControle ? true : false,
                };
                // on ne bascule sur
                // la branche
                // filiere que
                // depuis la rep,
                // pas depuis le
                // controle
                if (!scope.depuisControle)
                  resetDossierData.filiereId = scope.selectedFiliere;

                $rootScope.$broadcast(
                  'resetDossierArborescence',
                  resetDossierData
                );

                $rootScope.$broadcast('ajoutElementFiliere', {
                  filiereId: scope.selectedFiliere,
                  element_id: ftid,
                });

                scope.$emit('closeAddElemPopup');

                $rootScope.$broadcast('updateInstallTab', {
                  listeElementsFilieres: scope.listeElementsFilieres,
                  currentElementFiliere: scope.newFiliereElement,
                  listeTypeFilieres: scope.listeTypeFilieres,
                });

                scope.newFiliereElement = {};
                scope.newFiliereElement.groupe = groupes[0].id;
                // require('toastr').success("Élement
                // de filière
                // ajouté.");
                require('toastr').success('Élement de filière ajouté.', '', {
                  positionClass: 'toast-bottom-left',
                });
              });
            });
          } else {
            require('toastr').error(
              'On doit avoir une filière active pour pouvoir ajouter un element de filière!',
              '',
              {
                positionClass: 'toast-bottom-left',
              }
            );
          }
        };
      },
    };
  };

  ancAjoutElementFiliere.$inject = [
    'AncAppFactory',
    'gaDomUtils',
    'EditFactory',
    '$rootScope',
    'FeatureTypeFactory',
    '$q',
    'gaJsUtils',
  ];
  return ancAjoutElementFiliere;
});
