'use strict';
define([
  'angular',
  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'toastr',
  'ol3js',
  'ng-table',
], function(angular) {
  var module = angular.module('gc_directives_list', []);

  module.provider('gcDirectivesList', function() {
    this.$get = function() {
      var wikiUrl = function(u) {
        return 'http://support.altereo.fr/xwiki/wiki/kis/view/' + u;
      };
      var wikiUrlSearch = function(u) {
        return (
          'http://support.altereo.fr/xwiki/wiki/kis/view/Main/Search?text=' +
          u +
          '&f_type=DOCUMENT&f_locale=fr&f_locale=&r=1'
        );
      };

      var DirList = function() {
        this.listtoolsMetaData = function() {
          const _m = {};
          // Géo Traitements
          _m.geotreatmentwidget = {
            description: 'Géo Traitements',
            wiki: wikiUrl('Dashboard/Utilisation/Geotraitements/'),
          };
          // Lydec
          _m.aepnetworkeditwidget = {
            description: 'Edition Eau potable',
            wiki: wikiUrl('Dashboard/Utilisation/EditionEauPotable'),
          };
          _m.assnetworkeditwidget = {
            description: 'Edition Assainissement',
            wiki: wikiUrl('Dashboard/Utilisation/EditionAssainissement'),
          };
          _m.cotationeditwidget = {
            description: 'Edition des cotations',
            wiki: wikiUrl('Dashboard/Utilisation/EditionDesCotations'),
          };
          _m.elecbtnetworkeditwidget = {
            description: 'Edition Electicité BT',
            wiki: wikiUrl('Dashboard/Utilisation/EditionElecticiteBT'),
          };
          _m.elececpnetworkeditwidget = {
            description: 'Edition Electicité ECP',
            wiki: wikiUrl('Dashboard/Utilisation/EditionElecticiteECP'),
          };
          _m.elecmtnetworkeditwidget = {
            description: 'Edition Electicité HTA',
            wiki: wikiUrl('Dashboard/Utilisation/EditionElecticiteHTA'),
          };
          _m.electroncondraw = {
            description: 'Tronçons HTA',
            wiki: wikiUrl('Dashboard/Utilisation/TronçonsHTA'),
          };
          // Outils ANC
          _m.ancmapwidget = {
            description: 'Application ANC',
            wiki: wikiUrl('Dashboard/KISanc'),
          };
          // Outils BAC
          _m.bacmapwidget = {
            description: 'Application BAC',
            wiki: wikiUrl('Dashboard/KISbac'),
          };
          // Outils Cadastre
          _m.admninparamwidget = {
            description: 'Administration des paramètres',
            wiki: wikiUrl('Dashboard/KISCadastre'),
          };
          _m.majicdockwidget = {
            description: 'MAJIC',
            wiki: wikiUrl(
              'Dashboard/KISCadastre/#H3-PrE9sentationdesfonctionnalitE9smE9tier'
            ),
          };
          // Import / Export
          _m.csvgeocoder = {
            description: 'Géocodage de CSV',
            wiki: wikiUrl(
              'Dashboard/Administration/Geocodage/#H3Ajoutdesadresses'
            ),
          };
          _m.importdwgwidget = {
            description: 'Import DWG',
            wiki: wikiUrl('Dashboard/Utilisation/ImportDWG'),
          };
          _m.importgpxwidget = {
            description: 'Import GPX',
            wiki: wikiUrl('Dashboard/Utilisation/ImportGPX'),
          };
          _m.importxlsxwidget = {
            description: 'Import XLSX',
            wiki: wikiUrl('Dashboard/Utilisation/ImportXLSX'),
          };
          _m.importtransferlayerwidget = {
            description: 'Permet le transfert d\'objets d\'une couche à une autre.',
            wiki: wikiUrl('Dashboard/Utilisation/importTransferLayerWidget'),
          };
          _m.exportxlsxwidget = {
            description: 'Export XLSX',
            wiki: wikiUrl('Dashboard/Utilisation/ExportXLSX'),
          };
          _m.exportgeopackage = {
            description: 'Export Geopackage',
            wiki: wikiUrl('Dashboard/KIScollect/#H5Fondsdeplan'),
          };
          _m.imexmbtiles = {
            description: 'Export MBTiles',
            wiki: wikiUrl('Dashboard/Utilisation/MBTiles'),
          };
          _m.importdiverswidget = {
            description: 'Import CSV',
            wiki: wikiUrl('Dashboard/Utilisation/ImportCSV'),
          };
          _m.importdxfwidget = {
            description: 'Import DXF / DWG',
            wiki: wikiUrl('Dashboard/Utilisation/ImportDXF'),
          };
          _m.importexportwidget = {
            description: 'Import / Export	',
            wiki: wikiUrl('Dashboard/Utilisation/ImportExport'),
          };
          // Impression
          _m.atlas = {
            description: 'Atlas Géographique',
            wiki: wikiUrl('Dashboard/OutilsSIG/#HLacrE9ationd27atlas'),
          };
          _m.esriprint = {
            description: 'Impression',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.5-L27impression'),
          };
          _m.gaprintv2 = {
            description: 'Impression v2',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.5-L27impression'),
          };
          // Outils Métiers
          _m.dictwidgetdirective = {
            description: 'DICT',
            wiki: wikiUrl('Dashboard/Utilisation/DICT'),
          };
          _m.intervflowwidget = {
            description: "Gestionnaire d'interventions et de formulaires",
            wiki: wikiUrl('Dashboard/Outils/#H1-Editeurdeformulaires'),
          };
          _m.itvdirective = {
            description: 'Inspections televisees',
            wiki: wikiUrl('Dashboard/OutilsSIG/#HInspectionstE9lE9visE9es'),
          };
          _m.longitudinalprofilewidget = {
            description: 'Profil en long',
            wiki: wikiUrl('Dashboard/Utilisation/ProfilEnLong'),
          };
          _m.operis = {
            description: 'Operis',
            wiki: wikiUrl(''),
          };
          // Requêtage
          _m.elasticwidget = {
            description: 'Requeteur avance',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.4-LerequEAteur'),
          };
          _m.querywidget = {
            description: 'Requeteur simple',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.4-LerequEAteur'),
          };
          // Outils SIG
          _m.aboutwidget = {
            description: 'A Propos',
            wiki: wikiUrl('Dashboard/OutilsSIG/APropos'),
          };
          _m.gcannotationswidget = {
            description: 'Annotations',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.10-Annotation'),
          };
          _m.dashboardwidget = {
            description: 'Dashboard widget',
            wiki: wikiUrl('Dashboard/OutilsSIG/#HTableaudebord'),
          };
          _m.gcdefaultfilters = {
            description: 'Filtres de données',
            wiki: wikiUrl(
              'Dashboard/OutilsSIG/#HRE9aliserdesfiltressimplessurlesobjets'
            ),
          };
          _m.bizeditwidget = {
            description: "Edition avancee d'objets",
            wiki: wikiUrl('Dashboard/OutilsSIG/#HLemoded27E9ditionavancE9'),
          };
          _m.esrisymbolstyle = {
            description: 'Gestion webservices',
            wiki: wikiUrl('Dashboard/OutilsSIG/WebHome#HGestionwebservices'),
          };
          _m.executequerymanager = {
            description: 'Exécuter un fichier SQL',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.4-LerequEAteur'),
          };
          _m.geolocalisationwidget = {
            description:
              'Permet la localisation par adresse ou par coordonnees',
            wiki: wikiUrl(
              'Dashboard/OutilsSIG/#H2.3-LalocalisationE0l27adresseouparcoordonnE9es'
            ),
          };
          _m.localisationmultilevelwidget = {
            description:
              'Permet la localisation par zones avec plusieurs niveaux de précisions',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.3-localisationMultiLevel'),
          };
          _m.indigauwidget = {
            description: 'Indigau',
            wiki: wikiUrl('Dashboard/Utilisation/Indigau'),
          };
          _m.selectfeaturetreewidget = {
            description: 'Boite d`information',
            wiki: wikiUrl('Dashboard/Utilisation/Infobox'),
          };
          _m.layermanagerwidget = {
            description:
              "Le Géocatalogue (ou gestionnaire de couches) permet de gérer l'ordre, la visibilité, le style... des couches ",
            wiki: wikiUrl(
              'Dashboard/OutilsSIG/#H2.1-LeGE9ocatalogueougestionnairedecouches'
            ),
          };
          _m.galegend = {
            description: 'Légende',
            wiki: wikiUrl('Dashboard/OutilsSIG/#HAfficherlalE9gendedelacarte'),
          };
          _m.mapcatalogwidget = {
            description: 'Catalogue de cartes',
            wiki:wikiUrl(
              'Dashboard/Configurations/#H4-ParamE9trageducataloguedecartes'),
          };
          _m.mapModelMgtWidget = {
            description: 'Modèle de carte',
            wiki: wikiUrl('Dashboard/OutilsSIG/#HLemodE8ledecarte'),
          };
          _m.mapgcannotationswidget = {
            description: 'Annotations V2',
            wiki: wikiUrl('Dashboard/OutilsSIG/#H2.10-Annotation'),
          };
          _m.networkwidgetdirective = {
            description: 'Réseaux',
            wiki: wikiUrl('Dashboard/Utilisation/ParcoursReseau'),
          };
          _m.rasterwidget = {
            description: 'Raster',
            wiki: wikiUrl('Utilisation/ImageFdP/'),
          };
          _m.staticimagewidget = {
            description: 'Image statique',
            wiki: wikiUrl('Utilisation/ImageFdP/'),
          };
          _m.statistiquewidget = {
            description: 'Statistiques',
            wiki: wikiUrl('Dashboard/Utilisation/Statistiques'),
          };
          _m.dynamicstylewidget = {
            description: 'Styles Esri',
            wiki: wikiUrl(
              'Dashboard/Administration/SldEditor/#H1Interfacedel27E9diteur'
            ),
          };
          _m.tiercedirective = {
            description: 'Lien application externe',
            wiki: wikiUrl(
              'Dashboard/Administration/ParametrageDesModules/#H1.3Liens'
            ),
          };
          _m.urlsharing = {
            description: 'Partage de lien',
            wiki: wikiUrl('Dashboard/Utilisation/URLsharing'),
          };
          // Outils eau potable
          _m.aepinterventions = {
            description: 'Interventions',
            wiki: wikiUrl('Dashboard/Utilisation/Interventions'),
          };
          _m.mainaep = {
            description: 'Eau potable',
            wiki: wikiUrl('Dashboard/Utilisation/InterventionsEauPotable'),
          };
          _m.epanetexp = {
            description: 'Export EPANET',
            wiki: wikiUrl('Dashboard/Utilisation/ExportEPANET'),
          };
          // Yamoussoukro
          _m.cherchermodsupdirective = {
            description: 'Recherche pour modification',
            wiki: wikiUrl(''),
          };
          _m.choixprogrammedirective = {
            description: 'Programmation',
            wiki: wikiUrl(''),
          };
          _m.editobjectwidgetdirective = {
            description: 'Edition objets',
            wiki: wikiUrl(''),
          };
          _m.typeprojetdirective = {
            description: 'TypeProjet',
            wiki: wikiUrl(''),
          };
          _m.biztopologywidget = {
            description: 'Vérification de règles topologiques',
            wiki: wikiUrl(''),
          };
          return _m;
        };

        this.listtools = function() {
          return [
            {
              title: 'Geotreatment.widgetname',
              name: 'geotreatmentwidget',
              directive: 'geotreatmentwidget',
              categorie: 'tool.categorie.Geotreatment',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'networkedit.aepwidgetname',
              name: 'AEPNetworkEdit',
              categorie: 'tool.categorie.Lydec',
              directive: 'aepnetworkeditwidget',
              type: 'Panel',
              config: 'aepnetworkdefconfig',
            },
            {
              title: 'networkedit.asswidgetname',
              name: 'ASSNetworkEdit',
              categorie: 'tool.categorie.Lydec',
              directive: 'assnetworkeditwidget',
              type: 'Panel',
              config: 'assnetworkdefconfig',
            },
            {
              title: 'cotationedition.widgetname',
              name: 'Edit',
              categorie: 'tool.categorie.Lydec',
              directive: 'cotationeditwidget',
              type: 'Panel',
              config: 'cotationConfig',
            },
            {
              title: 'networkedit.elecbtwidgetname',
              name: 'ELECBTNetworkEdit',
              categorie: 'tool.categorie.Lydec',
              directive: 'elecbtnetworkeditwidget',
              type: 'Panel',
              config: 'elecbtnetworkdefconfig',
            },
            {
              title: 'networkedit.elececpwidgetname',
              name: 'ELECECPNetworkEdit',
              categorie: 'tool.categorie.Lydec',
              directive: 'elececpnetworkeditwidget',
              type: 'Panel',
              config: 'elececpnetworkdefconfig',
            },
            {
              title: 'networkedit.elecmtwidgetname',
              name: 'ELECMTNetworkEdit',
              categorie: 'tool.categorie.Lydec',
              directive: 'elecmtnetworkeditwidget',
              type: 'Panel',
              config: 'elecmtnetworkdefconfig',
            },
            {
              title: 'electroncondraw.widgetname',
              name: 'electroncondraw',
              directive: 'electroncondraw',
              categorie: 'tool.categorie.Lydec',
              type: 'Panel',
              config: 'configtronconelec',
            },
            {
              title: 'ancapp.widgetname',
              name: 'ancapp',
              directive: 'ancmapwidget',
              categorie: 'tool.categorie.Outil_ANC',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'bacapp.widgetname',
              name: 'bacapp',
              directive: 'bacmapwidget',
              categorie: 'tool.categorie.Outil_BAC',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'admninparamwidget.widgetname',
              name: 'ADMIN_PARAMS',
              directive: 'admninparamwidget',
              categorie: 'tool.categorie.Outil_Cadastre',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'majicwidget.widgetname',
              name: 'MAJIC',
              directive: 'majicdockwidget',
              categorie: 'tool.categorie.Outil_Cadastre',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'csvgeocoder.widgetname',
              name: 'csvgeocoder',
              directive: 'csvgeocoder',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'importdwgwidget.widgetname',
              name: 'importdwg',
              directive: 'importdwgwidget',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'exportGeopackage.widgetname',
              name: 'export_geopackage',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              directive: 'exportgeopackage',
              config: 'configname',
            },
            {
              title: 'importExportMBTILES.widgetname',
              name: 'import_export_mbtiles',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              directive: 'imexmbtiles',
              config: 'configname',
            },
            {
              title: 'importdiverswidget.widgetname',
              name: 'importdivers',
              directive: 'importdiverswidget',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'importdxfwidget.widgetname',
              name: 'importdxf',
              directive: 'importdxfwidget',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'importexport.widgetname',
              name: 'importexport',
              directive: 'importexportwidget',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'importgpxwidget.widgetname',
              name: 'importgpx',
              directive: 'importgpxwidget',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'importxlsxwidget.widgetname',
              name: 'importxlsx',
              directive: 'importxlsxwidget',
              categorie: 'tool.categorie.Outil_Metiers',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'importTransferLayerWidget.widgetname',
              name: 'importTransferLayer',
              directive: 'import-transfer-layer-widget',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'exportxlsxwidget.widgetname',
              name: 'exportxlsx',
              directive: 'exportxlsxwidget',
              categorie: 'tool.categorie.Outil_Metiers',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'importDocumentsWidget.widgetname',
              name: 'import_documents',
              directive: 'importdocumentswidget',
              categorie: 'tool.categorie.Outil_ImportExport',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'atlas.widgetname',
              name: 'atlas_cartographique',
              categorie: 'tool.categorie.Outil_Impression',
              type: 'Panel',
              directive: 'atlas',
              config: 'configname',
            },
            {
              title: 'esriprint.widgetname',
              name: 'esriprint',
              directive: 'esriprint',
              categorie: 'tool.categorie.Outil_Impression',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'printv2.widgetname',
              name: 'Print v2',
              categorie: 'tool.categorie.Outil_Impression',
              type: 'Panel',
              directive: 'gaprintv2',
              config: 'configname',
            },
            {
              title: 'dictwidget.widgetname',
              name: 'dictwidget',
              directive: 'dictwidgetdirective',
              categorie: 'tool.categorie.Outil_Metiers',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'intervflowwidget.widgetname',
              name: 'intervention_Workflow',
              directive: 'intervflowwidget',
              categorie: 'tool.categorie.Outil_Metiers',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'itv.title',
              name: 'itv',
              directive: 'itvdirective',
              categorie: 'tool.categorie.Outil_Metiers',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'longitudinalProfil.widgetname',
              name: 'longitudinalProfil.widgetname',
              directive: 'longitudinalprofilewidget',
              categorie: 'tool.categorie.Outil_Metiers',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'Operis',
              name: 'Operis',
              directive: 'operis',
              categorie: 'tool.categorie.Outil_Metiers',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'elasticwidget.widgetname',
              name: 'Elastic',
              directive: 'elasticwidget',
              categorie: 'tool.categorie.Outil_Requetage',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'query.widgetname',
              name: 'Request',
              categorie: 'tool.categorie.Outil_Requetage',
              type: 'Panel',
              directive: 'querywidget',
              config: 'configname',
            },
            {
              title: 'about.widgetname',
              name: 'aboutName',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              directive: 'aboutwidget',
              config: 'configname',
            },
            {
              title: 'annotations.widgetname',
              name: 'Annotation',
              directive: 'gcannotationswidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'dashBoard.widgetname',
              name: 'dashboard',
              directive: 'dashboardwidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'default_filters.widgetname',
              name: 'DefaultFilters',
              directive: 'gcdefaultfilters',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'editionbiz.widgetname',
              name: 'EditMetier',
              categorie: 'tool.categorie.Outil_SIG',
              directive: 'bizeditwidget',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'esrisymbolstyle.widgetname',
              name: 'esrisymbolstyle',
              directive: 'esrisymbolstyle',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'executQuery.widgetname',
              name: 'ExecutQueryManager',
              directive: 'executequerymanager',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'geolocalisation.widgetname',
              name: 'GeoLocation',
              directive: 'geolocalisationwidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'localisationMultiLevelWidget.widgetname',
              name: 'localisationMultiLevel',
              directive: 'localisationmultilevelwidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'indigauwidget.widgetname',
              name: 'Indigau Widget',
              directive: 'indigauwidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configindigau',
            },
            {
              title: 'selectfeaturetree.widgetname',
              name: 'InfoBox',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              directive: 'selectfeaturetreewidget',
              config: 'configname',
            },
            {
              title: 'layermanager.widgetname',
              name: 'LayerManager',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              directive: 'layermanagerwidget',
              config: 'configname',
            },
            {
              title: 'legend.widgetname',
              name: 'legend',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              directive: 'galegend',
              config: 'configname',
            },
            {
              title: 'mapcatalogwidget.widgetname',
              name: 'Map Catalog',
              directive: 'mapcatalogwidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'layermanager.mapmodel.widgetname',
              name: 'Map Model',
              directive: 'mapModelMgtWidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'model.network.title',
              name: 'networkwidget',
              directive: 'networkwidgetdirective',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'Raster',
              name: 'Raster',
              directive: 'rasterwidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'staticimagewidget.widgetname',
              name: 'staticimagewidget',
              directive: 'staticimagewidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'statistiquewidget.widgetname',
              name: 'statistiquewidget',
              directive: 'statistiquewidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'StyleDynamic.widgetname',
              name: 'StyleDynamic',
              directive: 'dynamicstylewidget',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'tierce.widgetname',
              name: 'Tierce',
              directive: 'tiercedirective',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'urlsharing.widgetname',
              name: 'urlsharing',
              directive: 'urlsharing',
              categorie: 'tool.categorie.Outil_SIG',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'aepintervention.widgetname',
              name: 'aep interventions',
              directive: 'aepinterventions',
              categorie: 'tool.categorie.Water',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'water.widgetname',
              name: 'eau',
              directive: 'mainaep',
              categorie: 'tool.categorie.Water',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'aepepanetexp.widgetname',
              name: 'epanetexp',
              directive: 'epanetexp',
              categorie: 'tool.categorie.Water',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'cherchermodsupdirective.widgetname',
              name: 'chercher',
              directive: 'cherchermodsupdirective',
              categorie: 'tool.categorie.Yamoussoukro',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'choixprogrammedirective.widgetname',
              name: 'choixprogramme',
              directive: 'choixprogrammedirective',
              categorie: 'tool.categorie.Yamoussoukro',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'editobjectwidgetdirective.widgetname',
              name: 'editobjectwidget',
              directive: 'editobjectwidgetdirective',
              categorie: 'tool.categorie.Yamoussoukro',
              type: 'Panel',
              config: 'configname',
            },

            {
              title: 'alerteManager.widgetname',
              directive: 'pcwinmanager',
              categorie: 'tool.categorie.Outil_Requetage',
              type: 'Panel',
              config: 'configname',
            },

            {
              title: 'omegaManager.widgetname',
              directive: 'omegamanager',
              categorie: 'tool.categorie.Outil_Requetage',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'TypeProjet',
              name: 'programmation_name',
              directive: 'typeprojetdirective',
              categorie: 'tool.categorie.Yamoussoukro',
              type: 'Panel',
              config: 'configname',
            },
            {
              title: 'biztopology.widgetname',
              name: 'biztopology',
              categorie: 'tool.categorie.Outil_SIG',
              directive: 'biztopologywidget',
              type: 'Panel',
              config: 'configname',
            }
          ];
        };

        this.listtoolbars = function() {
          return [
            {
              type: 'widget',
              title: 'screenshot svg',
              name: 'toolbarexportmapsvg',
              config: '',
              icone: 'fa fa-map',
            },
            {
              type: 'widget',
              title: 'screenshot',
              name: 'toolbarexportmap',
              config: '',
              icone: 'fa fa-camera',
            },
            {
              type: 'widget',
              title: 'gcmapplus.tbtooltip',
              name: 'gcmapplus',
              config: '',
              icone: 'glyphicon glyphicon-plus',
            },
            {
              type: 'widget',
              title: 'gcmapextent.tbtooltip',
              name: 'gcmapextent',
              config: '',
              icone: 'glyphicon glyphicon-fullscreen',
            },
            {
              type: 'widget',
              title: 'gcmapgeneral.tbtooltip',
              name: 'gcmapgeneral',
              config: '',
              icone: 'glyphicon glyphicon-move',
            },
            {
              type: 'widget',
              title: 'gcmapmoins.tbtooltip',
              name: 'gcmapmoins',
              config: '',
              icone: 'glyphicon glyphicon-minus',
            },
            {
              type: 'widget',
              title: 'openweathermap.tbtooltip',
              name: 'toolbarmeteo',
              config: '',
              icone: 'glyphicon glyphicon-cloud',
            },
            {
              type: 'widget',
              title: 'selectoolsbypolygon.tbtooltip',
              name: 'toolbarselecttoolbypolygon',
              config: '',
              icone: 'fa fa-object-group',
            },
            {
              type: 'widget',
              title: 'selectools.byline',
              name: 'toolbarselecttoolbyline',
              config: '',
              icone: 'fa fa-kis-selectedtoolsline',
            },
            {
              type: 'widget',
              title: 'selectools.tbtooltip',
              name: 'toolbarselecttool',
              config: '',
              icone: 'glyphicon glyphicon-edit',
            },
            {
              type: 'widget',
              title: 'selectoolsbypoint.tbtooltip',
              name: 'toolbarselecttoolbypoint',
              config: '',
              icone: 'glyphicon glyphicon-info-sign',
            },
            {
              type: 'widget',
              title: 'extractcoordinates.tbtooltip',
              name: 'toolbarextractcoordinates',
              config: '',
              icone: 'glyphicon glyphicon-map-marker  text-warning',
            },
            {
              type: 'widget',
              title: 'selectoolsbypointutilities.tbtooltip',
              name: 'toolbarselecttoolbypointutilities',
              config: '',
              icone: 'glyphicon glyphicon-info-sign text-danger',
            },
            {
              type: 'widget',
              title: 'selectoolsbypointutilities.tbtooltip_anc',
              name: 'toolbarselecttoolbypointutilities#2',
              config: '',
              params: {
                type: 'DossierANC',
                biz: 'anc',
              },
              icone: 'glyphicon glyphicon-info-sign text-info',
            },
            {
              type: 'widget',
              title: 'selectoolsbypointutilities.tbtooltip_bac',
              name: 'toolbarselecttoolbypointutilities#3',
              config: '',
              params: {
                type: 'DossierBAC',
                biz: 'bac',
              },
              icone: 'glyphicon glyphicon-info-sign text-success',
            },
            {
              type: 'widget',
              title: 'geolocation.tbtooltip',
              name: 'geolocationdirective',
              config: '',
              icone: 'glyphicon glyphicon-map-marker',
            },
            {
              type: 'widget',
              title: 'streetview.tbtooltip',
              name: 'toolbarstreetview',
              config: '',
              icone: 'fa fa-street-view',
            },
            {
              type: 'widget',
              title: 'filterdeactivate.tbtooltip',
              name: 'filterdeactivate',
              config: '',
              icone: 'fa fa-filter-circle-xmark-solid',
            },
            {
              type: 'widget',
              title: 'directions.tbtooltip',
              name: 'toolbardirections',
              config: '',
              icone: 'glyphicon glyphicon-road',
            },
            {
              type: 'widget',
              title: 'elevation.tbtooltip',
              name: 'toolbarelevation',
              config: '',
              icone: 'fa fa-line-chart',
            },
            {
              type: 'widget',
              title: 'measure.tbtooltip',
              name: 'toolbarmeasuredirective',
              config: 'b',
              icone: 'fa fa-kis-mesaure',
            },
            {
              type: 'widget',
              title: 'toolbarselectiontools.tbtooltip',
              name: 'toolbarselectiontoolsdirective',
              config: '',
              icone: 'fa fa-kis-selectiontools',
            },
            {
              type: 'widget',
              title: 'mapmodel.tbtooltip',
              name: 'toolbarmapmodeldirective',
              config: '',
              icone: 'fa fa-map-o',
            },
            {
              type: 'widget',
              title: 'importwms.tbtooltip',
              name: 'toolbarimportwms',
              config: 'd',
              icone: 'glyphicon glyphicon-import',
            },
            {
              type: 'widget',
              title: 'importwfs.tbtooltip',
              name: 'toolbarimportwfs',
              config: 'd',
              icone: 'glyphicon glyphicon-import',
            },
            {
              type: 'widget',
              title: 'basemap.tbtooltip',
              name: 'toolbarbasemap',
              config: '',
              icone: 'glyphicon glyphicon-th-large',
            },
            {
              type: 'widget',
              title: 'position.tbtooltip',
              name: 'toolbarposition',
              config: '',
              icone: 'glyphicon glyphicon-screenshot',
            },
            {
              type: 'widget',
              title: 'elastic.search.tbtooltip',
              name: 'elasticquickfilter',
              config: '',
              icone: 'fa fa-filter',
            },
            {
              type: 'widget',
              title: 'geosignet.tbtooltip',
              name: 'toolbargeosignet',
              config: '',
              icone: 'glyphicon glyphicon-tags',
            },
            {
              type: 'widget',
              title: 'about.tbtooltip',
              name: 'aboutwidget',
              config: '',
              icone: 'fa fa-exclamation',
            },
            {
              type: 'widget',
              title: 'historic.tbtooltip',
              name: 'toolbarmaphistoric',
              config: '',
              icone: 'fa fa-history',
            },
            {
              type: 'widget',
              title: 'overview.tbtooltip',
              name: 'toolbaroverview',
              config: '',
              icone: 'glyphicon glyphicon-picture',
            },
            {
              type: 'widget',
              title: 'Quick Filter',
              name: 'toolbarquickfilter',
              config: '',
              icone: 'glyphicon glyphicon-search',
            },
            {
              type: 'widget',
              title: 'StarQuery',
              name: 'toolbarquickquery',
              config: '',
              icone: 'glyphicon glyphicon-star-empty',
            },
            {
              type: 'widget',
              title: 'Quick Popup',
              name: 'toolbarquickpopup',
              config: '',
              icone: 'fa fa-comment',
            },
            {
              type: 'widget',
              title: 'info version',
              name: 'toolbarversionlib',
              config: '',
              icone: 'glyphicon glyphicon-question-sign',
            },
            {
              type: 'widget',
              title: 'Geocoder Reverse',
              name: 'gctoolbargeocoderreverse',
              config: '',
              icone: 'fa fa-map-marker',
            },
            {
              type: 'widget',
              title: 'Geocoder Reverse what3words',
              name: 'gctoolbargeocoderreversew3w',
              config: '',
              icone: '',
              imgsrc: 'img/svg/what3words/w3w_logo.png',
            },
            {
              type: 'widget',
              title: 'sharemapsocial.widgetname',
              name: 'toolbarsharemapsocial',
              config: '',
              icone: 'fa fa-share-alt',
            },
            {
              type: 'widget',
              title: 'selectools.buffer',
              name: 'buffersizewidget',
              config: '',
              icone: 'fa fa-chain-broken',
            },
            {
              type: 'widget',
              title: 'maprefresher.button',
              name: 'toolbarmaprefresher',
              config: '',
              icone: 'fa fa-refresh',
            },
            {
              type: 'widget',
              title: 'mapannotate.button',
              name: 'mapgcannotationswidget',
              config: '',
              icone: '',
              imgsrc: 'img/common/painting-icon-32.png',
            },
            {
              type: 'widget',
              title: 'geolocalisation.tbtooltip',
              name: 'geolocalisationbutton',
              config: '',
              icone: 'fa fa-thumb-tack',
            }
          ];
        };
      };
      return new DirList();
    };
  });

  return module;
});
