/**
 *
 */
'use strict';
define(function() {
  /**
   * Portals Ctrl
   * @param $scope
   * @param $rootScope
   * @param $window
   * @param $translate
   * @param RootFactory
   * @constructor
   * @param DataStoreFactory
   */
  var ConfigurationCtrl = function(
    $scope,
    $rootScope,
    $window,
    $translate,
    $filter,
    RootFactory,
    DataStoreFactory,
    gaDomUtils,
    CalendarFactory,
    $timeout,
    gaJsUtils,
    AlertHpoFactory
  ) {
    $scope.edit = false;
    var vkb = new vkbeautify();

    $scope.reloadConfiguration = function(bool) {
      if (bool) gaDomUtils.showGlobalLoader();
      RootFactory.getConfiguration(bool).then(
        function(res) {
          if (bool) gaDomUtils.hideGlobalLoader();
          if (res.data) {
            $scope.configuration = vkb.xml(res.data);
            $scope.oldConfig = $scope.configuration;
          } else {
            AlertHpoFactory.showErrorMessage(res);
          }
        },
        function(res) {
          if (bool) gaDomUtils.hideGlobalLoader();
          AlertHpoFactory.showErrorMessage(res);
        }
      );
    };
    $scope.reloadConfiguration(false);

    $scope.saveConfig = function() {
      var callback = function(isconfirm) {
        if (isconfirm) {
          gaDomUtils.showGlobalLoader();
          RootFactory.saveConfiguration($scope.configuration).then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (res.data) {
                $scope.oldConfig = $scope.configuration;
                $scope.edit = false;
                AlertHpoFactory.successSave();
              } else {
                AlertHpoFactory.showErrorMessage(res);
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        }
      };
      AlertHpoFactory.alertConfirmCallback(
        $filter('translate')('hpo.common.warning'),
        $filter('translate')('root.confguration.sur'),
        'warning',
        true,
        undefined,
        '#F50072',
        true,
        undefined,
        undefined,
        true,
        true,
        callback
      );
    };

    setTimeout(function() {
      $scope.maxheight = angular.element('#xgos_main').height() - 70 + 'px';
      angular.element('#textarea-config').height($scope.maxheight);
    }, 300);
  };

  ConfigurationCtrl.$inject = [
    '$scope',
    '$rootScope',
    '$window',
    '$translate',
    '$filter',
    'RootFactory',
    'DataStoreFactory',
    'gaDomUtils',
    'CalendarFactory',
    '$timeout',
    'gaJsUtils',
    'AlertHpoFactory',
  ];
  return ConfigurationCtrl;
});
