'use strict';
define([
  'angular',

  'modules/rights/services/UsersFactory',
  'modules/rights/services/GroupsFactory',
  'modules/rights/services/RolesFactory',
  'modules/rights/services/RightsFactory',
  'modules/rights/services/RestrictionFactory',
  'modules/rights/services/ExtraAuthenticationFactory',

  'modules/rights/controllers/UsersCtrl',
  'modules/rights/controllers/GroupsCtrl',
  'modules/rights/controllers/RolesCtrl',
  'modules/rights/controllers/RightsCtrl',
  'modules/rights/controllers/RestrictionCtrl',
  'modules/rights/controllers/ExtraAuthenticationCtrl',

  'modules/rights/directives/restrictionSelection',

  'angular-strap',
  'angular-strap.tpl',

  'angular-route',

  'toastr',
], function(
  angular,
  UsersFactory,
  GroupsFactory,
  RolesFactory,
  RightsFactory,
  RestrictionFactory,
  ExtraAuthenticationFactory,
  UsersCtrl,
  GroupsCtrl,
  RolesCtrl,
  RightsCtrl,
  RestrictionCtrl,
  ExtraAuthenticationCtrl,
  restrictionSelection
) {
  // Module
  var mod = angular.module('rights', []);

  // Services
  //mod.factory('RightsFactory',RightsFactory);

  mod.factory('UsersFactory', UsersFactory);
  mod.factory('GroupsFactory', GroupsFactory);
  mod.factory('RolesFactory', RolesFactory);
  mod.factory('RightsFactory', RightsFactory);
  mod.factory('RestrictionFactory', RestrictionFactory);
  mod.factory('ExtraAuthenticationFactory', ExtraAuthenticationFactory);

  mod.directive('restrictionSelection', restrictionSelection);

  // Controllers
  mod.controller('UsersCtrl', UsersCtrl);
  mod.controller('GroupsCtrl', GroupsCtrl);
  mod.controller('RolesCtrl', RolesCtrl);
  mod.controller('RightsCtrl', RightsCtrl);
  mod.controller('RestrictionCtrl', RestrictionCtrl);
  mod.controller('ExtraAuthenticationCtrl', ExtraAuthenticationCtrl);

  //route provider
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/users/', {
        templateUrl: 'js/XG/modules/' + 'rights/views/users.html',
        controller: UsersCtrl,
      });

      $routeProvider.when('/groups/', {
        templateUrl: 'js/XG/modules/' + 'rights/views/groups.html',
        controller: GroupsCtrl,
      });

      $routeProvider.when('/roles/', {
        templateUrl: 'js/XG/modules/' + 'rights/views/roles.html',
        controller: RolesCtrl,
      });

      $routeProvider.when('/restrictions/', {
        templateUrl: 'js/XG/modules/' + 'rights/views/restrictions.html',
        controller: RestrictionCtrl,
      });

      $routeProvider.when('/extra_authentication/', {
        templateUrl:
          'js/XG/modules/' + 'rights/views/extra_authentication.html',
        controller: ExtraAuthenticationCtrl,
      });
    },
  ]);
  return mod;
});
