'use strict';
define(function() {
  var templatebasewidget = function(ReportFactory) {
    return {
      templateUrl: 'js/XG/modules/report/views/reportGenerate.html',
      //            template:
      //                    '<button class="btn btn-default" type="button" title="Générer le rapport" ng-click="generate()" ng-show="!iswait">'+
      //                        '<span class="glyphicon glyphicon-open-file" ></span>'+
      //                    '</button>'+
      //                    '<img src="img/common/wait.gif" id="waitImg" ng-show="iswait"/>',
      restrict: 'A',
      scope: {
        reportName: '@', //la propriété prend la valeur évaluée de l'attribut (monodirectionnel)
        data: '@', //A MODIFIER en '=' SI l'objet data n'est pas pris en compte.
        dataStoreName: '@',
      },

      link: function(scope, element, attrs, ctrl) {
        scope.iswait = false;

        scope.generate = function() {
          scope.iswait = true;
          ReportFactory.getreport(
            scope.data,
            scope.reportName,
            scope.dataStoreName,
            false,
            'pdf'
          ).then(
            function(res) {
              scope.iswait = false;
              var resultObject = res.data;
              var blob = new Blob([resultObject], {
                type: 'application/pdf',
              });
              var objectUrl = URL.createObjectURL(blob);
              window.open(objectUrl);
              //Libération de la mémoire de l'objet URL
              //window.URL.revokeObjectURL();
            },
            function(res) {
              scope.iswait = false;
              require('toastr').error(
                'La génération du rapport a échoué:' + res.data
              );
            }
          );
        };
      },
    };
  };

  templatebasewidget.$inject = ['ReportFactory'];
  return templatebasewidget;
});
