'use strict';
define(function() {
  var jsonEditor = function(SharedFactory, PrintModelFactory) {
    return {
      restrict: 'AE',
      templateUrl: 'js/XG/modules/print/views/directives/jsonEditor.html',
      // controllerAs: 'ModelGUICtrl',
      scope: {
        jsonmodel: '=jsonmodel',
      },

      link: function(scope, element, attrs, ngModelCtrl) {
        //  scope.stringy = scope.updateModel (scope.jsonmodel) ;

        function string2JSON(text) {
          try {
            return angular.fromJson(text);
          } catch (err) {
            var errorMsg = 'JSON Invalid';
            require('toastr').error(errorMsg);
            return text;
          }
        }
        function setEditing(value) {
          scope.stringy = angular.copy(JSON2String(value));
        }

        function updateModel(value) {
          scope.jsonmodel = angular.fromJson(value);
        } //Vérification en cas de changement de nom

        // Initialisation de stringy
        setEditing(scope.jsonmodel);

        function JSON2String(object) {
          // NOTE that this will remove all $-prefixed values
          return angular.toJson(object);
        }

        //check for changes going out
        scope.$watch('stringy', function(newval, oldval) {
          if (newval != oldval) {
            updateModel(newval);
          }
        });

        //check for changes coming in
        scope.$watch('jsonmodel', function(newval, oldval) {
          if (newval != oldval) {
            setEditing(newval);
          }
        });

        //console.log(scope.stringy);
      },
    };
  };

  jsonEditor.$inject = ['SharedFactory', 'PrintModelFactory'];
  return jsonEditor;
});
