/////////////////////////////////////////////////////////////
// Gestion de la configuration des règles métiers.
/////////////////////////////////////////////////////////////
'use strict';
define(function() {
  var gcelement = function(
    ngTableParams,
    ngDialog,
    $filter,
    DocumentFactory,
    gaDomUtils,
    FilesFactory,
    ReportIndicatorFactory,
    ReportFactory,
    ApplicationFactory,
    DataStoreFactory,
    $rootScope
  ) {
    return {
      templateUrl:
        'js/XG/modules/model/views/directives/featuretypeactionsJasperGlobal.html',
      restrict: 'E',
      scope: {
        currentFormData: '=currentformdata',
      },
      link: function(scope) {
        ApplicationFactory.get().then(function(res) {
          scope.appnames = res.data
            .map(function(x) {
              if (x.type === 'MapApp') return x.name;
            })
            .filter(function(x) {
              if (x) return x;
            });
        });
        DataStoreFactory.get($rootScope.xgos.portal.uid).then(function(res) {
          scope.storeNames = res.data
            .map(function(x) {
              return x.name;
            })
            .filter(function(x) {
              if (x) return x;
            });
        });

        scope.currentFormData.type = $filter('translate')(
          'model.featuretypes.actions.jasper'
        );
        scope.currentFormData.typeInfo = 'JASPER';

        scope.typeChanged = function(rapport) {
          rapport.files = [];
          ReportIndicatorFactory.getAllReportNamesFromApplication(
            rapport.appname
          ).then(
            function(res) {
              rapport.files = res.data;
              if (rapport.file && rapport.appname)
                ReportFactory.getParams(rapport.file, rapport.appname).then(
                  function(res) {
                    rapport.parameters = undefined;
                    for (var i = 0; i < res.data.length; i++) {
                      i === 0 &&
                      (!rapport.parameters || rapport.parameters.length === 0)
                        ? (rapport.parameters = [
                            {
                              id: Math.floor(Math.random() * 10000),
                              name: res.data[i].name,
                              attribut: res.data[i].type,
                            },
                          ])
                        : rapport.parameters.push({
                            id: Math.floor(Math.random() * 10000),
                            name: res.data[i].name,
                            attribut: res.data[i].type,
                          });
                    }
                  },
                  function() {
                    require('toastr').error('error');
                  }
                );
            },
            function() {
              require('toastr').error('error');
            }
          );
        };

        if (angular.isUndefined(scope.currentFormData.rapports)) {
          scope.currentFormData.rapports = [
            { id: Math.floor(Math.random() * 10000) },
          ];
          scope.typeChanged(scope.currentFormData.rapports[0]);
        }

        scope.types = [
          $filter('translate')('model.featuretypes.actions.JasperModel'),
        ];

        /**
         * Paramètres du tableau listant les règles associées au currentfeaturetype passé à cette directive
         */
        scope.tableParams = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.currentFormData.rapports.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.currentFormData.rapports.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        scope.removeRapport = function(idx) {
          scope.currentFormData.rapports.splice(idx, 1);
          if (idx === 0 && scope.currentFormData.rapports.length === 0)
            scope.currentFormData.rapports = [
              { id: Math.floor(Math.random() * 10000) },
            ];
          scope.typeChanged(scope.currentFormData.rapports[0]);
          scope.tableParams.reload();
        };

        scope.uploadedFile = function(input) {
          var form = new FormData();
          var file = input.files[0];
          form.append('file', file);
          gaDomUtils.showGlobalLoader();
          ReportFactory.addjasperfile(form).then(
            function(res) {
              if (res.data !== '' && res.status === 200) {
                require('toastr').info(res.data);
                try {
                  if (file.name === '' || file.name === null) return;
                  var idx;
                  for (
                    var i = 0;
                    i < scope.currentFormData.rapports.length;
                    i++
                  ) {
                    if (scope.currentFormData.rapports[i].$selected) {
                      idx = i;
                      break;
                    }
                  }
                  scope.currentFormData.rapports[idx].fileUploaded = file;

                  scope.currentFormData.rapports[idx].file = file.name.replace(
                    '.jrxml',
                    ''
                  );
                  if (
                    angular.isUndefined(
                      scope.currentFormData.rapports[idx].files
                    ) ||
                    scope.currentFormData.rapports[idx].files === ''
                  )
                    scope.currentFormData.rapports[idx].files = [];
                  if (
                    scope.currentFormData.rapports[idx].files.indexOf(
                      file.name.replace('.jrxml', '')
                    ) === -1
                  )
                    scope.currentFormData.rapports[idx].files.push(
                      file.name.replace('.jrxml', '')
                    );
                  scope.tableParams.reload();
                } catch (e) {
                  console.log(e.message);
                } finally {
                  gaDomUtils.hideGlobalLoader();
                }
              }
            },
            function(reason) {
              require('toastr').error('error');
              console.error(reason);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * Paramètres utilisateur
         */

        scope.attributeTypes = [
          {
            id: 'java.lang.Double',
            label: 'java.lang.Double',
          },
          {
            id: 'java.util.Date',
            label: 'java.util.Date',
          },
          {
            id: 'java.lang.String',
            label: 'java.lang.String',
          },
          {
            id: 'java.lang.Boolean',
            label: 'java.lang.Boolean',
          },
          {
            id: 'java.lang.Integer',
            label: 'java.lang.Integer',
          },
          {
            id: 'java.sql.Timestamp',
            label: 'java.sql.Timestamp',
          },
          {
            id: 'ids.list',
            label: 'ids.list',
          },
          {
            id: 'user',
            label: 'user',
          },
        ];

        scope.openParametes = function(rapport) {
          scope.rapportParameters = angular.copy(rapport);
          if (angular.isUndefined(scope.rapportParameters.parameters))
            scope.rapportParameters.parameters = [
              { id: Math.floor(Math.random() * 100000) },
            ];
          scope.p = ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.featuretypes.actions.users.parameters.html',
            scope: scope,
            closeByDocument: false,
            className: 'ngdialog-theme-plain width800',
            //preCloseCallback : scope.closeDiag
          });
        };

        scope.addParameter = function() {
          scope.rapportParameters.parameters.push({
            id: Math.floor(Math.random() * 100000),
          });
          scope.tableParamsParameters.reload();
        };

        scope.removeParameter = function(idx) {
          scope.rapportParameters.parameters.splice(idx, 1);
          scope.tableParamsParameters.reload();
        };

        scope.tableParamsParameters = new ngTableParams(
          {
            page: 1, // show first page
            count: 10, // count per page
          },
          {
            total: 0, // length of data
            getData: function($defer, params) {
              var displayedTab = scope.rapportParameters.parameters.slice(
                (params.page() - 1) * params.count(),
                params.page() * params.count()
              );

              params.total(scope.rapportParameters.parameters.length); // set total for recalc pagination
              $defer.resolve(displayedTab);
            },
          }
        );

        scope.validerParameters = function() {
          for (var i = 0; i < scope.currentFormData.rapports.length; i++) {
            if (
              scope.currentFormData.rapports[i].id ===
              scope.rapportParameters.id
            ) {
              scope.currentFormData.rapports[i].parameters = angular.copy(
                scope.rapportParameters.parameters
              );
              break;
            }
          }
          scope.tableParams.reload();
        };

        scope.closeDiag = function() {
          scope.p.close();
        };

        /**
         * Paramètres utilisateur
         */
      },
    };
  };

  gcelement.$inject = [
    'ngTableParams',
    'ngDialog',
    '$filter',
    'DocumentFactory',
    'gaDomUtils',
    'FilesFactory',
    'ReportIndicatorFactory',
    'ReportFactory',
    'ApplicationFactory',
    'DataStoreFactory',
    '$rootScope',
  ];
  return gcelement;
});
