'use strict';
define(function() {
  var gcelement = function() {
    return {
      templateUrl:
          'js/XG/modules/model/views/modals/modal.network.attributeInput.html',
      restrict: 'EA',
      scope: {
        attributeName: '=',
        list: '=',
        ngModel: '=',
        onAutocompleteChange: '=?',
        attributeDisplayed: '=',
        attributeUsed: '=',
        savedCustomValues: '=?',
        required: '=?'
      },
      link: function(scope) {
        scope.customValue = '';
        scope.showAddCustomValue = false;
        scope.toggleAddCustomValue = () => {
          scope.showAddCustomValue = !scope.showAddCustomValue;
        };

        /**
         * Ajout de la valeur personnalisée
         */
        scope.addCustomValue = () => {
          if (scope.customValue !== '') {
            if (!scope.list.find(el => el[scope.attributeDisplayed] === scope.customValue)) {
              const newValue = {
                [scope.attributeDisplayed]: scope.customValue,
                [scope.attributeUsed]: scope.customValue
              };
              scope.list.push(newValue);
              scope.savedCustomValues.push(newValue);
            }
            scope.ngModel = scope.customValue;
            scope.toggleAddCustomValue();
          }
        };
      },
    };
  };

  gcelement.$inject = [];
  return gcelement;
});
