'use strict';
define(function() {
  const NetworksCtrl = function($scope, NetworkFactory, FeatureTypeFactory,
    $filter, extendedNgDialog, gaDomUtils) {
    // Edit Groups Tabs
    $scope.tabs = [
      {
        title: 'common.general',
        content:
          'js/XG/modules/model/views/modals/modal.network.networks_general.html'
      },
      {
        title: 'model.network.mainNetwork',
        content:
          'js/XG/modules/model/views/modals/modal.network.edges_and_nodes.html',
      }
    ];
    $scope.tabs.activeTab = 0;




    /**
     * Prepare les données pour les select / dualListBox du formulaire d'édition réseau
     */
    const prepareDataForNetworkForm = () => {
      $scope.tabs.activeTab = 0;

      // Structure de stockage des valeurs personnalisées pour les champs attributs
      if (!$scope.edit_resource.saveCustomValues) {
        $scope.edit_resource.saveCustomValues = {
          network: [],
          equipment: []
        };
      }
      var visibleEdgesTypes = getVisibleFeatureTypes(
        $scope.edit_resource.edgesTypes
      );
      // Edges DualListBox
      $scope.dLBEdgesData = {
        leftData: angular.copy(visibleEdgesTypes),
        leftDisplayAttribute: 'name',
        rightData: angular.copy($scope.edgesFeatureTypes),
        rightDisplayAttribute: 'name',
        leftTitle: 'model.network.partEdges',
        rightTitle: 'model.network.allEdges',
        source: 'right',
      };
      $scope.networkLinearAttributesChange();

      var visibleNodesTypes = getVisibleFeatureTypes(
        $scope.edit_resource.nodesTypes
      );
      // Nodes DualListBox
      $scope.dLBNodesData = {
        leftData: angular.copy(visibleNodesTypes),
        leftDisplayAttribute: 'name',
        rightData: angular.copy($scope.nodesFeatureTypes),
        rightDisplayAttribute: 'name',
        leftTitle: 'model.network.partNodes',
        rightTitle: 'model.network.punctual',
        source: 'right',
      };

      // Equipment DualListBox
      $scope.dLBEquipmentData = {
        leftData: angular.copy(getVisibleFeatureTypes($scope.edit_resource.equipmentTypes)),
        leftDisplayAttribute: 'name',
        rightData: angular.copy($scope.nodesFeatureTypes),
        rightDisplayAttribute: 'name',
        leftTitle: 'model.network.networkEquipment',
        rightTitle: 'model.network.punctual',
        source: 'right',
      };
      $scope.networkEquipmentAttributesChange();

      // Connection DualListBox
      $scope.dLBConnectionLinear = {
        leftData: angular.copy(getVisibleFeatureTypes($scope.edit_resource.connectionLinearTypes)),
        leftDisplayAttribute: 'name',
        rightData: angular.copy($scope.edgesFeatureTypes),
        rightDisplayAttribute: 'name',
        leftTitle: 'model.network.connectionLinear',
        rightTitle: 'model.network.allEdges',
        source: 'right',
      };
      $scope.dLBAmont = {
        leftData: angular.copy(getVisibleFeatureTypes($scope.edit_resource.connectionAmontTypes)),
        leftDisplayAttribute: 'name',
        rightData: angular.copy($scope.nodesFeatureTypes),
        rightDisplayAttribute: 'name',
        leftTitle: 'model.network.extAmont',
        rightTitle: 'model.network.punctual',
        source: 'right',
      };
      $scope.dLBAval = {
        leftData: angular.copy(getVisibleFeatureTypes($scope.edit_resource.connectionAvalTypes)),
        leftDisplayAttribute: 'name',
        rightData: angular.copy($scope.nodesFeatureTypes),
        rightDisplayAttribute: 'name',
        leftTitle: 'model.network.extAval',
        rightTitle: 'model.network.punctual',
        source: 'right',
      };
      $scope.dLBConnectionEquipment = {
        leftData: angular.copy(getVisibleFeatureTypes($scope.edit_resource.connectionEquipmentTypes)),
        leftDisplayAttribute: 'name',
        rightData: angular.copy($scope.nodesFeatureTypes),
        rightDisplayAttribute: 'name',
        leftTitle: 'model.network.connectionEquipment',
        rightTitle: 'model.network.punctual',
        source: 'right',
      };
      if ($scope.edit_resource.communeComponent) {
        const communeComponent = FeatureTypeFactory.getFeatureByName($scope.edit_resource.communeComponent);
        if (communeComponent) {
          $scope.communeAttributeList = communeComponent.attributes;
        } else {
          require('toastr').error(
              $filter('translate')('model.network.cannotAccessComponent') + $scope.edit_resource.communeComponent
          );
        }
      }
      $scope.selectedCreateRuleOption = '';
      $scope.resetRules = false;
      $scope.formIsDirty = false;
      $scope.generateTabsOnNetworkTypeChange();
      $scope.networkTypes = [
        {
          type: 'ass',
          alias: $filter('translate')('model.network.ass')
        },
        {
          type: 'eap',
          alias: $filter('translate')('model.network.eap')
        },
        {
          type: 'irr',
          alias: $filter('translate')('model.network.irr')
        },
        {
          type: 'other',
          alias: $filter('translate')('model.network.other')
        }
      ];
      $scope.selectedCreateRuleOption = { value: 'deleteAllRulesBefore' };
    };

    // Lors de l'édition/création d'un réseau
    $scope.$on('data_modal', prepareDataForNetworkForm);

    /**
     * Fonction appelée au changement dans la dualListBox des réseaux pour charger la liste des attributs du premier choix
     */
    $scope.networkLinearAttributesChange = () => {
      if ($scope.dLBEdgesData && $scope.dLBEdgesData.leftData.length > 0) {
        $scope.networkLinearAttributes =
            [...$scope.dLBEdgesData.leftData[0].attributes,
            ...$scope.edit_resource.saveCustomValues.network];
      } else {
        $scope.networkLinearAttributes = [];
      }
    };

    /**
     * Fonction appelée au changement dans la dualListBox des équipement de réseaux pour charger la liste des attributs du premier choix
     */
    $scope.networkEquipmentAttributesChange = () => {
      if ($scope.dLBEquipmentData && $scope.dLBEquipmentData.leftData.length > 0) {
        $scope.networkEquipmentAttributes =
            [...$scope.dLBEquipmentData.leftData[0].attributes,
            ...$scope.edit_resource.saveCustomValues.equipment];
      } else {
        $scope.networkEquipmentAttributes = [];
      }
    };

    /**
     * Create or update a Group
     */
    $scope.editNetwork = () => {
      $scope.edit_resource.nodesTypes = arrayOfFTypesToNetworkTypes(
        $scope.dLBNodesData.leftData
      );
      $scope.edit_resource.edgesTypes = arrayOfFTypesToNetworkTypes(
        $scope.dLBEdgesData.leftData
      );
      $scope.edit_resource.equipmentTypes = arrayOfFTypesToNetworkTypes(
        $scope.dLBEquipmentData.leftData
      );
      $scope.edit_resource.connectionLinearTypes = arrayOfFTypesToNetworkTypes(
        $scope.dLBConnectionLinear.leftData
      );
      $scope.edit_resource.connectionAmontTypes = arrayOfFTypesToNetworkTypes(
        $scope.dLBAmont.leftData
      );
      $scope.edit_resource.connectionAvalTypes = arrayOfFTypesToNetworkTypes(
        $scope.dLBAval.leftData
      );
      $scope.edit_resource.connectionEquipmentTypes = arrayOfFTypesToNetworkTypes(
        $scope.dLBConnectionEquipment.leftData
      );


      if ($scope.isNewResource) {
        NetworkFactory.addnetwork($scope.edit_resource).then(function() {
          $scope.isNewResource = false;
        });
      } else {
        NetworkFactory.updatenetwork(
          $scope.edit_resource,
          $scope.oldcopy &&
            $scope.oldcopy.name &&
            $scope.oldcopy.name !== $scope.edit_resource.name
            ? $scope.oldcopy.name
            : ''
        ).then(() => {
          // -- Récupérer la liste des réseaux actualisées
          // -- pour un affichage correcte dans la page web.
          NetworkFactory.get(false);
        });
      }
    };

    /**
     * Group removal
     */
    $scope.removeNetwork = function() {
      NetworkFactory.deletenetwork($scope.edit_resource.name).then(function() {
        //$scope.tableParams.total($scope.currentResources.length).reload();
      });
    };

    function arrayOfFTypesToNetworkTypes(fTypes) {
      var networkTypes = [];
      angular.forEach(fTypes, function(featureType) {
        networkTypes.push({
          ftiUID: featureType.uid,
          ftiFilter: null,
        });
      });
      return networkTypes;
    }

    function getVisibleFeatureTypes(networksTypes) {
      var visibleFeatureTypes = [];

      angular.forEach(networksTypes, function(networkType) {
        for (
          var i = 0;
          i < FeatureTypeFactory.resources.featuretypes.length;
          i++
        )
          if (
            FeatureTypeFactory.resources.featuretypes[i].uid ==
            networkType.ftiUID
          ) {
            visibleFeatureTypes.push(
              FeatureTypeFactory.resources.featuretypes[i]
            );
            break;
          }
      });

      return visibleFeatureTypes;
    }

    function initEdgesAndNodesTypes(featureTypes) {
      $scope.edgesFeatureTypes = [];
      $scope.nodesFeatureTypes = [];
      angular.forEach(featureTypes, function(featureType) {
        if (featureType.geographic) {
          if (featureType.typeInfo == 'LINE')
            $scope.edgesFeatureTypes.push(featureType);
          else if (featureType.typeInfo == 'POINT')
            $scope.nodesFeatureTypes.push(featureType);
        }
      });
    }
    /**
     * Network loading
     */
    $scope.currentResources = NetworkFactory.resources.networks;

    if (NetworkFactory.resources.networks.length === 0) {
      NetworkFactory.get(false).then(() => {
        $scope.currentResources = NetworkFactory.resources.networks;
      });
    }

    // Chargement de la liste des composants de type ponctuel, linéaire
    // Stockage de tous les types dans componentList pour le gcautocomplete de commune
    if (FeatureTypeFactory.resources.featuretypes.length > 0) {
      initEdgesAndNodesTypes(FeatureTypeFactory.resources.featuretypes);
      $scope.componentsList = FeatureTypeFactory.resources.featuretypes;
    } else {
      FeatureTypeFactory.get().then(function() {
        initEdgesAndNodesTypes(FeatureTypeFactory.resources.featuretypes);
        $scope.componentsList = FeatureTypeFactory.resources.featuretypes;
      });
    }


    /**
         EditList Directive configuration
         */
    $scope.editListCfg = {
      dataModule: 'model',
      resource_type: 'network',
      cols: ['name', 'uid'],
      removeFunction: $scope.removeNetwork,
      defautValues: [
        {
          k: 'minNodesToParse',
          v: 10,
        },
        {
          k: 'maxNodesToParse',
          v: 60,
        },
        {
          k: 'nodesIncrementWalk',
          v: 10,
        },
        {
          k: 'delayToReload',
          v: 0,
        },
      ],
    };

    /**
     * Génération des onglets dans la configuration du réseau en fonction du type de réseau
     */
    $scope.generateTabsOnNetworkTypeChange = () => {
      // Ajout des onglets
      const consideredNetworks = ['ass', 'eap', 'irr'];
      if ($scope.edit_resource && (consideredNetworks.includes($scope.edit_resource.networkType))) {
        if(!$scope.tabs.find(it => it.title === 'model.network.connection')) {
          $scope.tabs.push({title: 'model.network.connection',
          content: 'js/XG/modules/model/views/modals/modal.network.connection.html'});
        }
        if(!$scope.tabs.find(it => it.title === 'model.network.attributes')) {
          $scope.tabs.push({title: 'model.network.attributes',
          content: 'js/XG/modules/model/views/modals/modal.network.attributes.html'});
        }
      // Suppression des onglets
      } else {
        let index = $scope.tabs.findIndex(it => it.title === 'model.network.connection');
        if(index !== -1) {
          $scope.tabs.splice(index, 1);
        }
        index = $scope.tabs.findIndex(it => it.title === 'model.network.attributes');
        if(index !== -1) {
          $scope.tabs.splice(index, 1);
        }
      }
    };

    /**
     * Génération de la liste des attributs pour le choix de l'attribut Commune
     */
    $scope.generateCommuneAttributeList = () => {
      if ($scope.edit_resource.communeComponent) {
        $scope.communeAttributeList = FeatureTypeFactory.getFeatureByName($scope.edit_resource.communeComponent).attributes
        delete $scope.edit_resource.communeAttribute;
      }
    };

    /**
     * Marque le formulaire comme ayant été modifié,
     * formIsDirty est utilisé pour désactiver le bouton de génération des règles métiers
     */
    $scope.makeFormDirty = () => {
      $scope.formIsDirty = true;
    };

    /**
     * Ouverture de la fenêtre de configuration de la génération des règles métiers
     */
    $scope.openRuleGeneration = () => {
      extendedNgDialog.open({
        template: 'js/XG/modules/model/views/modals/modal.network.generateRules.html',
        className: 'ngdialog-theme-plain width600 miniclose',
        closeByDocument: false,
        scope: $scope,
        title: $filter('translate')('model.network.ruleGenerationTitle'),
        draggable: true
      });
    };

    /**
     * Création automatique des règles métiers
     */
    $scope.launchRulesCreation = () => {
      gaDomUtils.showGlobalLoader();
      NetworkFactory.createRules($scope.edit_resource, $scope.selectedCreateRuleOption.value).then(
          () => {
            swal({
              title: $filter('translate')('model.network.successGeneratingRules'),
              type: 'success',
              showCancelButton: false,
            });
            // Actualisation des features dans le front pour l'affichage dans l'onglet composants
            FeatureTypeFactory.get(true);
          },
          () => {
            swal({
              title: $filter('translate')('model.network.failureGeneratingRules'),
              type: 'error',
              showCancelButton: false
            });
          }).finally(() => {
            gaDomUtils.hideGlobalLoader();
        });
      };
  };

  NetworksCtrl.$inject = ['$scope', 'NetworkFactory', 'FeatureTypeFactory', '$filter', 'extendedNgDialog', 'gaDomUtils'];
  return NetworksCtrl;
});
