'use strict';
define(function() {
  var PcwinFactory = function($http) {
    var PcwinFactory = {};
    /**
     * Class : PcwinFactory Factory WebServices récupération des alertes
     */

    /**
     * Function: getPagedMesuresList
     */
    function getPagedMesuresList(senddata) {
      let promise = $http.post(
        '/services/{portalid}/pcwin/getPagedMesuresListAll',
        senddata
      );
      return promise;
    }

    /**
     * Function: getDataFromPcwinJson
     * Récupère les numéros des stations et les paramètres spécifiés depuis pcwin.json
     * En cas d'absence du fichier, on récupère tous les résultats de l'API
     */
    const getDataFromPcwinJson = () => {
      return $http.get(
        '/services/{portalid}/pcwin/getDataFromPcwinJson?f=json');
    }

    /**
     * Function: updatePcwinJsonFile
     */
    const updatePcwinJsonFile = (senddata)=>{
      return $http.post('/services/{portalid}/pcwin/updatePcwinJsonFile?f=json',senddata);
    }

    /**
     * Function: getPagedAlarmsList
     */
    function getPagedAlarmsListAll(senddata) {
      var promise = $http.post(
        '/services/{portalid}/pcwin/getPagedAlarmsListAll',
        senddata
      );
      return promise;
    }

    /**
     * Function: getPagedAlarmsList
     */
    function updateStationAlerte(senddata) {
      var promise = $http.post(
        '/services/{portalid}/pcwin/updateStationAlerte',
        senddata
      );
      return promise;
    }

    return {
      PcwinFactory: PcwinFactory,
      getPagedAlarmsListAll: getPagedAlarmsListAll,
      updateStationAlerte: updateStationAlerte,
      getPagedMesuresList: getPagedMesuresList,
      getDataFromPcwinJson: getDataFromPcwinJson,
      updatePcwinJsonFile: updatePcwinJsonFile
    };
  };
  PcwinFactory.$inject = ['$http'];
  return PcwinFactory;
});
