'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $translate,
    EditTypesFactory,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.setDateAttribute.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {
        //scope.result = {};
        scope.rule.name = 'SetDateAttribute';
        scope.rule.type = 'OnEnd';

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update,
          EditTypesFactory.editTypes.updateattributes,
        ];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$translate',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
