'use strict';
define(function() {
  var validateinput = function() {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/validateinput.html',
      restrict: 'EA',
      scope: {
        value: '=',
        restrict: '=',
        validated: '=',
        isDisabled: '=?',
        onBlur: '&?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.validated = true;
        scope.required = attrs.hasOwnProperty('required');

        // check value against restrict
        scope.$watch('value', function(value) {
          var valid = true;
          if (value && angular.isArray(scope.restrict)) {
            scope.restrict.forEach(function(r) {
              if (value.indexOf(r) != -1) {
                valid = false;
              }
            });
          }
          scope.validated = valid;
        });

        scope.blurAction = function() {
          if (angular.isDefined(attrs.onBlur)) {
            scope.onBlur();
          }
        };
      },
    };
  };

  validateinput.$inject = [];
  return validateinput;
});
