'use strict';
define(function() {
  let restrictedinput = (ngDialog) => {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/restrictedinput.html',
      restrict: 'EA',
      scope: {
        res: '=',
        ftid: '=',
        field: '=',
      },
      link: function(scope) {
        /**
         * Select a value from the restricted table
         */
        scope.selectRestrictedValue = () => {
          if (!scope.field) {
            require('toastr').error(
              'Please specify what field to search data on'
            );
            return;
          }

          // on initialise le conteneur de la sélection d'objets dans un objet
          // pour éviter les pbs de transmission de scope d'AngularJS entre restrictedInput et gcdatatable
          scope.selectedValue = {features: []};

          let restrictedDialog = ngDialog.open({
            template:
              'js/XG/modules/common/views/directives/modal.restrictedinput.html',
            className: 'ngdialog-theme-plain width800',
            closeByDocument: false,
            scope: scope,
          });

          scope.setSelectedValue = () => {
            restrictedDialog.close();
            scope.res = scope.selectedValue.features[0].properties[scope.field];
          };
        };
      },
    };
  };

  restrictedinput.$inject = ['ngDialog'];
  return restrictedinput;
});
