/**
 *
 */
'use strict';
define(function() {
  var RelationFormFieldl2Ctrl = function(
    $scope,
    FeatureTypeFactory,
    RelationFormFieldl2Factory,
    QueryFactory,
    ngDialog,
    EditFactory,
    GlobalServices,
    gaJsUtils
  ) {
    //-- Initialize some variables.
    $scope.panel = {};
    $scope.relatedObjects = {};
    $scope.relatedObjects.features = [];
    $scope.relatedObjectsScopeId = $scope.$id;
    $scope.selectedObjectId = null;
    $scope.thisId = $scope.$id;
    $scope.thisSelectId = 'select_' + $scope.$id;
    $scope.showTable = false;
    $scope.useTableSelect = false;
    $scope.selectedObject = {};

    $scope.dialogContent =
      "<div ChercherModSupDirective my-config='config_chercher_arguments'></div>";

    //-- Get field description.
    if ($scope.theField01 == null) {
      if ($scope.$parent != null) {
        if ($scope.$parent.theField01 != null)
          $scope.theField01 = $scope.$parent.theField01;
        else if ($scope.$parent.$parent != null)
          $scope.theField01 = $scope.$parent.$parent.theField01;
      }
    }

    $scope.$on('askForRelatedTableDesc', function(event, data) {
      if ($scope.theField01.tableDesc != undefined)
        $scope.$broadcast('gotTableDesc', {
          tableDesc: $scope.theField01.tableDesc,
          config: $scope.theField01.inlineConfig,
        });
    });

    /*
    	 *
TODO
A virer semble t il


    	$scope.getRelatedObject = function()
		{
			$scope.$broadcast("gotTableDesc",{"tableDesc":$scope.theField01.tableDesc, "config":$scope.theField01.inlineConfig});
  		    var where = $scope.theField01.relation.fieldEnd+"="+$scope.theField01.objectId;
			RelationFormFieldl2Factory.getRelatedObjects($scope.theField01.tableDesc.uid,where).then
			  (
			   function()
			   {
				    $scope.emptyRelatedObjectList();
				    $scope.addResObjectsToRelObjects();
				   	if ($scope.relatedObjects.features.length!=0)
				   	   {
  			    		//-- Get input values (set from input fields)
					   	if ($scope.panel!=null && $scope.relatedObjects.features!=0)
					   	   {
      			    		for (var propertyName in $scope.relatedObjects.features[0].properties)
      			    			if ($scope.panel.objectFields!=undefined)
      			    				$scope.panel.objectFields[ propertyName ] = $scope.relatedObjects.features[0].properties[ propertyName ];
					   	   }
					   	if ($scope.relatedObjects.features.length!=0)
					   		$scope.$broadcast("gotRelatedObjects",{"objects":$scope.relatedObjects});
				   	   }
				   	$scope.refreshList();
	 		   }
			  );
		};

    	//-- If ID is provided then get related objects
    	if ($scope.theField01.objectId!=null)
           {
    		//-- Get table description
    		$scope.theField01.tableDesc = RelationFormFieldl2Factory.tablesgetfinfo($scope.theField01.datastoreName,$scope.theField01.relation.componentEnd);
    		//-- Get related object
    		$scope.getRelatedObject();
    	   }
*/

    //-- Only one object in the relation so line number for the list is 1.
    //-- If 1-N or M-N relation then list may have many lines
    //-- and the line number may be configured.

    var conf = $scope.theField01.inlineConfig;
    if ($scope.theField01.relation.occurence == '1-1') {
      $scope.theField01.lineNumber = 1;
      //-- With 1 to 1 relation no list needed if related information
      //-- has to be input directly in the "widget".
      $scope.theField01.showList =
        !$scope.theField01.fieldDesc.inlineInput &&
        $scope.theField01.stepsConfig == undefined;
    } else {
      if (conf != null && conf.displayAs == 'table') {
        $scope.showTable = true;
      } else {
        $scope.theField01.showList = true;
        if (conf == null || conf.list == null || conf.list.lineNumber == null)
          $scope.theField01.lineNumber = 5;
        else $scope.theField01.lineNumber = conf.list.lineNumber;
      }
    }

    //-- Select list default width will be 200px unless defined in configuration.
    if (conf == null || conf.list == null || conf.list.width == null)
      $scope.theField01.width = '200px';
    else $scope.theField01.width = conf.list.width;

    if (
      $scope.theField01.inlineConfig != null &&
      $scope.theField01.inlineConfig.contentType == 'panelContainer'
    ) {
      $scope.panel.fieldDesc = $scope.theField01.relation.componentEndDescField;
      $scope.panel.objectFields = [];
      if ($scope.theField01.inlineConfig.excludedFields == null)
        $scope.panel.excludedFields = [];
      else
        $scope.panel.excludedFields =
          $scope.theField01.inlineConfig.excludedFields;
      if ($scope.theField01.inlineConfig.fieldOrder != undefined)
        $scope.panel.fieldOrder = $scope.theField01.inlineConfig.fieldOrder;
      if ($scope.theField01.inlineConfig.moreInputs != undefined)
        $scope.panel.moreInputsConfig =
          $scope.theField01.inlineConfig.moreInputs;
      if ($scope.theField01.inlineConfig.panelFields != undefined)
        $scope.panel.panelFields = $scope.theField01.inlineConfig.panelFields;
    }

    if ($scope.theField01.inlineConfig != null)
      $scope.orderingField = $scope.theField01.inlineConfig.orderingField;
    $scope.maxOrder = 0;

    /**
     *  TODO: open object form with some link in order to be informed
     *        of newly created object(s).
     *        yyyyyyyyyyyyyyyyyyyyyyyyyyy
     */
    $scope.openRelatedForm = function() {};

    $scope.resources = RelationFormFieldl2Factory.resources;

    $scope.emptyRelatedObjectList = function() {
      $scope.relatedObjects.features.splice(
        0,
        $scope.relatedObjects.features.length
      );
    };

    $scope.addResObjectsToRelObjects = function() {
      var features = $scope.resources.objects.features;

      for (var ind = 0; ind < features.length; ind++)
        $scope.relatedObjects.features.push(features[ind]);
    };

    $scope.getRelatedObjectForObjIdMnGetEndObject = function(
      tableDesc,
      idValue
    ) {
      //var where = $scope.theField01.relation.fieldStart+'='+idValue;
      //RelationFormFieldl2Factory.getRelatedObjects(tableDesc.uid,where).then
      QueryFactory.get(tableDesc.uid, idValue).then(function(res) {
        $scope.resources.objects = res.data;
        $scope.emptyRelatedObjectList();
        $scope.addResObjectsToRelObjects();
        if (res.data.features.length != 0) {
          if ($scope.panel.objectFields == undefined)
            $scope.panel.objectFields = [];
          //-- Get input values (set from input fields)
          for (var propertyName in $scope.panel.objectFields)
            $scope.panel.objectFields[propertyName] =
              res.data.features[0].properties[propertyName];

          //-- Store first feature Id in case it is needed later.
          $scope.panel.objectId = QueryFactory.getFeatureId(
            $scope.relatedObjects.features[0]
          );
        }
        $scope.refreshList();
      });
    };

    /**
     *     This function goes through the relation table to the end table
     *  in order to get the related objects.
     *  When M-N relation by default we add a command to open a useTableSelect component.
     */
    $scope.getRelatedObjectForObjIdMn = function(objId) {
      var tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.datastoreName,
        $scope.theField01.relation.componentEnd
      );
      $scope.relMnRelationTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.datastoreName,
        $scope.theField01.relation.name
      );
      var where = $scope.theField01.relation.fieldEnd + '=' + objId;
      $scope.useTableSelect = true;
      $scope.theField01.showList = true;
      $scope.theField01.objectId00 = objId;
      if (objId != null) {
        RelationFormFieldl2Factory.getRelatedObjects(
          $scope.relMnRelationTableDesc.uid,
          where
        ).then(function(res) {
          var ind,
            relations = [],
            idEndComponent = '';

          $scope.theField01.objectId = $scope.theField01.objectId00;
          $scope.emptyRelatedObjectList();
          $scope.refreshList();
          for (ind = 0; ind < res.data.features.length; ind++)
            relations.push(res.data.features[ind]);

          for (ind = 0; ind < relations.length; ind++) {
            if (idEndComponent != '') idEndComponent += ',';
            idEndComponent +=
              relations[ind].properties[$scope.theField01.relation.fieldStart];
          }
          if (idEndComponent != '')
            $scope.getRelatedObjectForObjIdMnGetEndObject(
              tableDesc,
              idEndComponent
            );
        });
      }
    };

    $scope.getRelatedObjectForObjId11ou1N = function(objId) {
      var where, uid;
      where = $scope.theField01.relation.fieldEnd + '=' + objId;
      $scope.theField01.objectId00 = objId;
      if (objId != null) {
        if ($scope.panel != undefined && $scope.panel.uid != undefined)
          uid = $scope.panel.fieldDesc.uid;
        else if (
          $scope.theField01.relation != undefined &&
          $scope.theField01.relation.componentEndDescField != undefined
        ) {
          uid = $scope.theField01.relation.componentEndDescField.uid;
        }
        RelationFormFieldl2Factory.getRelatedObjects(uid, where).then(
          function() {
            $scope.theField01.objectId = $scope.theField01.objectId00;
            $scope.emptyRelatedObjectList();
            $scope.resources = RelationFormFieldl2Factory.resources;
            $scope.addResObjectsToRelObjects();
            if ($scope.relatedObjects.features.length != 0) {
              //-- Get input values (set from input fields)
              for (var propertyName in $scope.panel.objectFields)
                $scope.panel.objectFields[propertyName] =
                  $scope.relatedObjects.features[0].properties[propertyName];

              //-- Store first feature Id in case it is needed later.
              //-- One later case we need it is when we use table4updl2.
              //-- This case suppose only one object is gotten at this level
              //-- anyway it's not possible to use table4updl2 when
              //-- in this place we get more than one child.
              $scope.panel.objectId = QueryFactory.getFeatureId(
                $scope.relatedObjects.features[0]
              );
            }
            $scope.refreshList();
          }
        );
      }
    };

    $scope.getRelatedObjectForObjId = function(objId) {
      if ($scope.theField01.field.indexOf('signat') != -1) var fg = 'rr';
      if ($scope.theField01.relation.occurence == 'N-M')
        $scope.getRelatedObjectForObjIdMn(objId);
      else $scope.getRelatedObjectForObjId11ou1N(objId);
    };

    /**
     *     Called when broadcast from main container says the parent object
     *  has been created in the DataBase.
     *  As a parameter the object id of the new object is received.
     */
    $scope.$on('gotObjectId', function(event, data) {
      //-- In case this relation is in a step container it is not directly
      //-- in relation with the main object, so we have to ignore the objectId.
      if (
        $scope.theField01.relation.componentEnd == data.layerName ||
        $scope.theField01.relation.componentStart == data.layerName
      ) {
        $scope.theField01.objectId00 = data.objectId;
        if (data.objectId == null) $scope.theField01.objectId = null;
        else $scope.getRelatedObjectForObjId($scope.theField01.objectId00);
      }
    });

    //if ($scope.objectId!=undefined && $scope.theField01.objectId==undefined)
    if ($scope.theField01.objectId != undefined)
      $scope.getRelatedObjectForObjId($scope.theField01.objectId);

    /**
     *
     */
    $scope.stringDateCorrectlyFormatted = function(value) {
      var indPos, year, month, day;

      indPos = value.indexOf('-');
      if (indPos == -1) indPos = value.indexOf('/');

      if (indPos == 4) {
        year = value.substr(0, 4);
        month = value.substr(5, 2);
        day = value.substr(8, 2);
      } else if (indPos == 2) {
        year = value.substr(6, 4);
        month = value.substr(3, 2);
        day = value.substr(0, 2);
      }

      if (parseInt(month) > 12) {
        indPos = month;
        month = day;
        day = indPos;
      }
      return year + '-' + month + '-' + day + 'T12:00:00.000-0300';
    };

    /**
     *
     */
    $scope.getValueFor = function(desc, fieldName, value) {
      for (var ind1 = 0; ind1 < desc.attributes.length; ind1++)
        if (desc.attributes[ind1].name == fieldName) {
          if (typeof value == 'boolean') return value;
          if (!desc.attributes[ind1].fieldTypeIsString && value == '')
            return null;
          if (desc.attributes[ind1].fieldTypeIsDate) {
            if (value == undefined) return null;
            if (value.trim == undefined)
              //-- Date value is not a string so we assume it is a Date object.
              return (
                '' +
                value.getFullYear() +
                '-' +
                (1 + value.getMonth()) +
                '-' +
                value.getDate() +
                'T12:00:00.000+0000'
              );
            return $scope.stringDateCorrectlyFormatted(value);
            //return "2016-01-02T12:00:00.000+0000";
          }
        }

      return value;
    };

    /**
     *
     */
    $scope.showErrorMessage = function(message) {
      //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
      var errorMsg = '<h4>Erreur</h4> ';
      errorMsg += '<br/><h4>Details</h4> ' + message;
      require('toastr').error(errorMsg);
    };

    /**
     *       Update the related object with information stored on the fields.
     *    This is available only for 1-1 relation.
     *    For a 1-N relation, there is no update in the inline management
     *    (only add or delete).
     */
    $scope.updateRelatedObject = function() {
      var propertyName;
      //-- There must be an object but we avoid to be in an non understandable situation.
      //-- 30/01/2015 In case of a 1-n or M-N relation the related object list may be empty.
      if ($scope.relatedObjects.features == 0) {
        if ($scope.relation.theField01.relation.occurence == '1-1')
          $scope.showErrorMessage('Objet en relation absent');
      } else {
        //-- Get input values (set from input fields)
        for (propertyName in $scope.panel.objectFields) {
          if (
            $scope.relatedObjects.features[0].properties.hasOwnProperty(
              propertyName
            )
          )
            $scope.relatedObjects.features[0].properties[
              propertyName
            ] = $scope.getValueFor(
              $scope.panel.fieldDesc,
              propertyName,
              $scope.panel.objectFields[propertyName]
            );
        }
        RelationFormFieldl2Factory.updateObjects(
          $scope.panel.fieldDesc.uid,
          $scope.relatedObjects.features
        ).then(function() {});
      }
    };

    /**
     *     Called when broadcast from main container because the user asked to commit
     *  his modifications.  This is called only when update mode is global.
     */
    $scope.$on('updateAsked', function(event, data) {
      $scope.updateRelatedObject();
    });

    /**
     * An empty function i needed, else the "valueChanged" function will do something
     * as it is inherited from parent.
     */
    $scope.valueChanged = function() {
      var toto;
      //-- If the object ID is set then we are updating an existing object.
      //-- Furthermore if the update mode is not "global" which means
      //-- it is "inline" set or at least by default we have to update the record.
      if (
        $scope.objectId != null &&
        $scope.theField01.updateMode != 'global' &&
        $scope.theField01.relation.occurence == '1-1'
      ) {
        $scope.updateRelatedObject();
      }
    };

    /**
     *
     */
    $scope.refreshList = function() {
      var ind, indPt, opt, elt;

      elt = document.getElementById($scope.thisSelectId);
      //-- When "inline" input for the relation the select element has not been created.
      if (elt == null) return;
      for (ind = elt.options.length - 1; ind >= 0; ind--) elt.remove(ind);
      if ($scope.orderingField != null) {
        //-- IF A SORT FIELD IS GIVEN
        //-- Sort the related objects on ordering field.
        //-- Get max value for ordering field.
        $scope.maxOrder = 0;
        $scope.relatedObjects.features.sort(function(a, b) {
          if (a.properties[$scope.orderingField] == null) return -1;
          if (b.properties[$scope.orderingField] == null) return 1;
          if (
            a.properties[$scope.orderingField] >
            b.properties[$scope.orderingField]
          )
            return 1;
          if (
            a.properties[$scope.orderingField] <
            b.properties[$scope.orderingField]
          )
            return -1;
          // a doit etre egale a b
          return 0;
        });
        if (
          $scope.relatedObjects.features[
            $scope.relatedObjects.features.length - 1
          ] != null
        )
          $scope.maxOrder =
            $scope.relatedObjects.features[
              $scope.relatedObjects.features.length - 1
            ].properties[$scope.orderingField];
      }
      for (ind = 0; ind < $scope.relatedObjects.features.length; ind++) {
        opt = document.createElement('option');
        opt.value = QueryFactory.getFeatureId(
          $scope.relatedObjects.features[ind]
        );
        if ($scope.theField01.relatedObjectFields != undefined) {
          var optText = '';
          for (
            var indField = 0;
            indField < $scope.theField01.relatedObjectFields.length;
            indField++
          ) {
            var tableDesc, fn;
            if ($scope.theField01.relation.componentEndDescField == undefined)
              tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
                $scope.theField01.datastoreName,
                $scope.theField01.relation.componentEnd
              );
            else tableDesc = $scope.theField01.relation.componentEndDescField;
            var attDesc = tableDesc.attributes;
            fn = $scope.theField01.relatedObjectFields[indField].field;
            var value = $scope.relatedObjects.features[ind].properties[fn];
            optText +=
              GlobalServices.formatFieldValueToStringForDisplaying(
                value,
                attDesc,
                fn
              ) + '   ';
          }
          opt.text = optText;
        } else if ($scope.theField01.relatedObjectField != undefined)
          opt.text =
            $scope.relatedObjects.features[ind].properties[
              $scope.theField01.relatedObjectField.field
            ];
        else opt.text = $scope.relatedObjects.features[ind].id;
        //    			 opt.onClick = function() {};
        elt.options.add(opt);
      }
    };

    /**
     *     As angular model for this select with this implementation
     *  does not set $scope.selectedObjectId, we have to read it here
     *  from the select DOM element.
     */
    $scope.getSelectedObjId = function() {
      var elt;

      elt = document.getElementById($scope.thisSelectId);
      if (elt.selectedIndex == -1) return;
      $scope.selectedObjectId = elt.options[elt.selectedIndex].value;
    };

    /**
     *      Method called on button click event in order to remove a related object from the database.
     */
    $scope.delRelatedObject = function() {
      $scope.getSelectedObjId();
      RelationFormFieldl2Factory.delRelatedObject(
        $scope.panel.fieldDesc.uid,
        $scope.selectedObjectId
      ).then(
        //-- After removing get the list of related objects to display the list
        //-- of related object which really are in the database.
        function() {
          $scope.refreshObjectsListFromDB();
        }
      );
    };

    /**
     *     Get related objects then clear and load related objects
     *  in this module list (HTML select element).
     */
    $scope.refreshObjectsListFromDB = function() {
      var where;
      where =
        $scope.theField01.relation.fieldEnd + '=' + $scope.theField01.objectId;
      RelationFormFieldl2Factory.getRelatedObjects(
        $scope.panel.fieldDesc.uid,
        where
      ).then(function() {
        $scope.emptyRelatedObjectList();
        $scope.addResObjectsToRelObjects();
        $scope.refreshList();
      });
    };

    /**
     *      Method called on button click event in order to create an object in the database.
     */
    $scope.addRelatedObject = function() {
      var ind, ind2;
      var newObj, fn;
      var attributes;
      newObj = {};

      //-- Build a clean object with only physical fields (no relation).
      attributes = $scope.theField01.relation.componentEndDescField.attributes;
      for (ind = 0; ind < attributes.length; ind++) {
        fn = attributes[ind].name;
        newObj[fn] = GlobalServices.getValueForDB(
          $scope.panel.fieldDesc.uid,
          fn,
          $scope.panel.objectFields[fn],
          ind
        );
      }
      newObj[$scope.theField01.relation.fieldEnd] = $scope.theField01.objectId;
      if ($scope.orderingField != null)
        newObj[$scope.orderingField] = ++$scope.maxOrder;
      //-- Insert the object into the database.
      RelationFormFieldl2Factory.addRelatedObject(
        $scope.panel.fieldDesc.uid,
        newObj,
        $scope.theField01.relation.componentEnd
      ).then(function() {
        $scope.refreshObjectsListFromDB();
      });
    };

    /**
     *      Method called on button click event in order
     *   to change the position of an object in a list.
     *   Depending on the step parameter value, the object will be moved up or down.
     */
    $scope.moveObject = function(step) {
      var ind1, ind2, ordre, d, id;

      $scope.getSelectedObjId();
      for (ind1 = 0; ind1 < $scope.relatedObjects.features.length; ind1++) {
        id = QueryFactory.getFeatureId($scope.relatedObjects.features[ind1]);
        if (id == $scope.selectedObjectId) {
          ind2 = ind1 + step;
          if (ind2 >= 0 && ind2 < $scope.relatedObjects.features.length) {
            ordre =
              $scope.relatedObjects.features[ind1].properties[
                $scope.orderingField
              ];
            $scope.relatedObjects.features[ind1].properties[
              $scope.orderingField
            ] =
              $scope.relatedObjects.features[ind2].properties[
                $scope.orderingField
              ];
            $scope.relatedObjects.features[ind2].properties[
              $scope.orderingField
            ] = ordre;
            $scope.refreshList();
            d = new Date();
            $scope.lastOrderingACtionTime = d.getTime();
            setTimeout($scope.updateObjects, 750);
            break;
          }
        }
      }
    };

    $scope.updateObjects = function() {
      var d = new Date();

      if (d.getTime() - $scope.lastOrderingACtionTime > 749) {
        RelationFormFieldl2Factory.updateObjects(
          $scope.panel.fieldDesc.uid,
          $scope.relatedObjects.features
        ).then(function() {
          $scope.refreshObjectsListFromDB();
        });
      }
    };

    $scope.relatedNotAlreadySelected = function(objectId) {
      //-- Look for object amongst the listed ones.
      for (var ind = 0; ind < $scope.relatedObjects.features.length; ind++)
        //-- Object found so return FALSE (already selected)
        if ($scope.relatedObjects.features[ind].id == objectId) return false;
      //-- Object not found so return TRUE (not already selected)
      return true;
    };

    /**
     *      Called by ngDialog opened for child object selection (related objects).
     *   When called it creates the relations between the current object
     *   and the selected ones.
     *
     *   @param {Object} objectIds
     */
    $scope.tableSelectSelectionDone = function(objectIds) {
      var ind, indPt;
      var features;

      //-- Build GeoJSON object describing the objects we want to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      for (ind = 0; ind < objectIds.length; ind++) {
        if ($scope.relatedNotAlreadySelected(objectIds[ind])) {
          features.features[ind] = {};
          features.features[ind].type = 'feature';
          features.features[ind].properties = {};
          indPt = objectIds[ind].indexOf('.');
          if (indPt != -1)
            features.features[ind].properties[
              $scope.theField01.relation.fieldStart
            ] = objectIds[ind].substr(indPt + 1);
          else
            features.features[ind].properties[
              $scope.theField01.relation.fieldStart
            ] = objectIds[ind];
          features.features[ind].properties[
            $scope.theField01.relation.fieldEnd
          ] = $scope.theField01.objectId;
          features.features[ind].geometry = {};
        }
      }

      //-- No new object in relation so don't need to add something.
      if (features.features.length == 0) return;

      EditFactory.add($scope.relMnRelationTableDesc.uid, features).then(
        function(res) {
          var errorMsg;

          if (res.statusText != 'OK' || res.data.errors.length != 0) {
            //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
            gaJsUtils.errorMessage(
              "Echec de l'ajout d'un objet en base !",
              res.data.errors[0]
            );
          } else {
            $scope.getRelatedObjectForObjId($scope.theField01.objectId);
          }
        }
      );
    };

    /**
     *       Function triggerd by user add command click.
     *  This add functionn open the list of possible related objects.
     *  It is opened as a ngDialog, which may have the add object
     *  possibility depending on the content of the configuration file.
     */
    $scope.openTableSelect = function() {
      var template;
      var childScope = $scope.$new(true, $scope);

      childScope.ConfigName = $scope.theField01.configName;
      childScope.tableSelectSelectionDone = $scope.tableSelectSelectionDone;
      childScope.meAsNgDialog = ngDialog;
      template =
        "<div TableSelectAndUpdateDirective style='width:100%;overflow-x:scroll;'></div>";
      ngDialog.open({
        template: template,
        plain: true,
        scope: childScope,
        className: 'ngdialog-theme-plain width800',
      });
    };

    $scope.removeSelectedObjFromRelation = function() {
      var id = $scope.selectedObject.id;
      if (id != undefined) {
        //-- A related object has been selected so we have to remove the relation
        //-- -1- Get the record in the relation table
        var where;
        where = $scope.theField01.relation.fieldStart + '=' + id;
        where += ' and ';
        where +=
          $scope.theField01.relation.fieldEnd +
          '=' +
          $scope.theField01.objectId;
        QueryFactory.data($scope.relMnRelationTableDesc.uid, where).then(
          function(res) {
            //-- There should only be one record for a relation between 2 objects
            //-- so the result should be the feature we want to remove.
            if (res.data.features.length != 0)
              EditFactory.remove(
                $scope.relMnRelationTableDesc.uid,
                QueryFactory.getFeatureId(res.data.features[0])
              ).then(function() {
                $scope.getRelatedObjectForObjId($scope.theField01.objectId);
              });
          }
        );
      }
    };
  };

  RelationFormFieldl2Ctrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'RelationFormFieldl2Factory',
    'QueryFactory',
    'ngDialog',
    'EditFactory',
    'GlobalServices',
    'gaJsUtils',
  ];
  return RelationFormFieldl2Ctrl;
});
